/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.DynamicPriceConfigByDate;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class HotelRoom
extends APINode {
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="base_price")
    private String mBasePrice = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="margin_level")
    private String mMarginLevel = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="room_id")
    private String mRoomId = null;
    @SerializedName(value="sale_price")
    private String mSalePrice = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    HotelRoom() {
    }

    public HotelRoom(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public HotelRoom(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public HotelRoom fetch() throws APIException {
        HotelRoom newInstance = HotelRoom.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static HotelRoom fetchById(Long id, APIContext context) throws APIException {
        return HotelRoom.fetchById(id.toString(), context);
    }

    public static ListenableFuture<HotelRoom> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return HotelRoom.fetchByIdAsync(id.toString(), context);
    }

    public static HotelRoom fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<HotelRoom> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<HotelRoom> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<HotelRoom>(context, "", "/", "GET", HotelRoom.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<HotelRoom>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<HotelRoom>(context, "", "/", "GET", HotelRoom.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static HotelRoom loadJSON(String json, APIContext context, String header) {
        HotelRoom hotelRoom = (HotelRoom)HotelRoom.getGson().fromJson(json, HotelRoom.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(hotelRoom.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        hotelRoom.context = context;
        hotelRoom.rawValue = json;
        hotelRoom.header = header;
        return hotelRoom;
    }

    public static APINodeList<HotelRoom> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<HotelRoom> hotelRooms = new APINodeList<HotelRoom>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        hotelRooms.add(HotelRoom.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return hotelRooms;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            hotelRooms.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        hotelRooms.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            hotelRooms.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            hotelRooms.add(HotelRoom.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                hotelRooms.add(HotelRoom.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            hotelRooms.add(HotelRoom.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return hotelRooms;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        hotelRooms.add(HotelRoom.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return hotelRooms;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        hotelRooms.add(HotelRoom.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return hotelRooms;
                }
                hotelRooms.clear();
                hotelRooms.add(HotelRoom.loadJSON(json, context, header));
                return hotelRooms;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return HotelRoom.getGson().toJson((Object)this);
    }

    public APIRequestGetPricingVariables getPricingVariables() {
        return new APIRequestGetPricingVariables(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public String getFieldBasePrice() {
        return this.mBasePrice;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldMarginLevel() {
        return this.mMarginLevel;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldRoomId() {
        return this.mRoomId;
    }

    public String getFieldSalePrice() {
        return this.mSalePrice;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public HotelRoom copyFrom(HotelRoom instance) {
        this.mApplinks = instance.mApplinks;
        this.mBasePrice = instance.mBasePrice;
        this.mCurrency = instance.mCurrency;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mImages = instance.mImages;
        this.mMarginLevel = instance.mMarginLevel;
        this.mName = instance.mName;
        this.mRoomId = instance.mRoomId;
        this.mSalePrice = instance.mSalePrice;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<HotelRoom> getParser() {
        return new APIRequest.ResponseParser<HotelRoom>(){

            @Override
            public APINodeList<HotelRoom> parseResponse(String response, APIContext context, APIRequest<HotelRoom> request, String header) throws APIException.MalformedResponseException {
                return HotelRoom.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<HotelRoom> {
        HotelRoom lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"applinks", "base_price", "currency", "description", "id", "images", "margin_level", "name", "room_id", "sale_price", "url"};

        @Override
        public HotelRoom getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public HotelRoom parseResponse(String response, String header) throws APIException {
            return HotelRoom.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public HotelRoom execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public HotelRoom execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<HotelRoom> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<HotelRoom> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, HotelRoom>(){

                public HotelRoom apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestBasePriceField() {
            return this.requestBasePriceField(true);
        }

        public APIRequestGet requestBasePriceField(boolean value) {
            this.requestField("base_price", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestMarginLevelField() {
            return this.requestMarginLevelField(true);
        }

        public APIRequestGet requestMarginLevelField(boolean value) {
            this.requestField("margin_level", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestRoomIdField() {
            return this.requestRoomIdField(true);
        }

        public APIRequestGet requestRoomIdField(boolean value) {
            this.requestField("room_id", value);
            return this;
        }

        public APIRequestGet requestSalePriceField() {
            return this.requestSalePriceField(true);
        }

        public APIRequestGet requestSalePriceField(boolean value) {
            this.requestField("sale_price", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }

    public static class APIRequestGetPricingVariables
    extends APIRequest<DynamicPriceConfigByDate> {
        APINodeList<DynamicPriceConfigByDate> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"checkin_date", "prices", "prices_pretty", "id"};

        @Override
        public APINodeList<DynamicPriceConfigByDate> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<DynamicPriceConfigByDate> parseResponse(String response, String header) throws APIException {
            return DynamicPriceConfigByDate.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<DynamicPriceConfigByDate> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<DynamicPriceConfigByDate> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<DynamicPriceConfigByDate>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<DynamicPriceConfigByDate>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<DynamicPriceConfigByDate>>(){

                public APINodeList<DynamicPriceConfigByDate> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetPricingVariables(String nodeId, APIContext context) {
            super(context, nodeId, "/pricing_variables", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPricingVariables setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPricingVariables setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPricingVariables requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPricingVariables requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPricingVariables requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPricingVariables requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPricingVariables requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPricingVariables requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPricingVariables requestCheckinDateField() {
            return this.requestCheckinDateField(true);
        }

        public APIRequestGetPricingVariables requestCheckinDateField(boolean value) {
            this.requestField("checkin_date", value);
            return this;
        }

        public APIRequestGetPricingVariables requestPricesField() {
            return this.requestPricesField(true);
        }

        public APIRequestGetPricingVariables requestPricesField(boolean value) {
            this.requestField("prices", value);
            return this;
        }

        public APIRequestGetPricingVariables requestPricesPrettyField() {
            return this.requestPricesPrettyField(true);
        }

        public APIRequestGetPricingVariables requestPricesPrettyField(boolean value) {
            this.requestField("prices_pretty", value);
            return this;
        }

        public APIRequestGetPricingVariables requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPricingVariables requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

