/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class InsightsValue
extends APINode {
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="earning_source")
    private String mEarningSource = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="engagement_source")
    private String mEngagementSource = null;
    @SerializedName(value="message_type")
    private String mMessageType = null;
    @SerializedName(value="messaging_channel")
    private String mMessagingChannel = null;
    @SerializedName(value="monetization_tool")
    private String mMonetizationTool = null;
    @SerializedName(value="recurring_notifications_entry_point")
    private String mRecurringNotificationsEntryPoint = null;
    @SerializedName(value="recurring_notifications_frequency")
    private String mRecurringNotificationsFrequency = null;
    @SerializedName(value="recurring_notifications_topic")
    private String mRecurringNotificationsTopic = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="value")
    private Object mValue = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static InsightsValue loadJSON(String json, APIContext context, String header) {
        InsightsValue insightsValue = (InsightsValue)InsightsValue.getGson().fromJson(json, InsightsValue.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(insightsValue.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        insightsValue.context = context;
        insightsValue.rawValue = json;
        insightsValue.header = header;
        return insightsValue;
    }

    public static APINodeList<InsightsValue> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InsightsValue> insightsValues = new APINodeList<InsightsValue>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        insightsValues.add(InsightsValue.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return insightsValues;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            insightsValues.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        insightsValues.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            insightsValues.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            insightsValues.add(InsightsValue.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                insightsValues.add(InsightsValue.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            insightsValues.add(InsightsValue.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return insightsValues;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        insightsValues.add(InsightsValue.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return insightsValues;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        insightsValues.add(InsightsValue.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return insightsValues;
                }
                insightsValues.clear();
                insightsValues.add(InsightsValue.loadJSON(json, context, header));
                return insightsValues;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InsightsValue.getGson().toJson((Object)this);
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public InsightsValue setFieldCampaignId(String value) {
        this.mCampaignId = value;
        return this;
    }

    public String getFieldEarningSource() {
        return this.mEarningSource;
    }

    public InsightsValue setFieldEarningSource(String value) {
        this.mEarningSource = value;
        return this;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public InsightsValue setFieldEndTime(String value) {
        this.mEndTime = value;
        return this;
    }

    public String getFieldEngagementSource() {
        return this.mEngagementSource;
    }

    public InsightsValue setFieldEngagementSource(String value) {
        this.mEngagementSource = value;
        return this;
    }

    public String getFieldMessageType() {
        return this.mMessageType;
    }

    public InsightsValue setFieldMessageType(String value) {
        this.mMessageType = value;
        return this;
    }

    public String getFieldMessagingChannel() {
        return this.mMessagingChannel;
    }

    public InsightsValue setFieldMessagingChannel(String value) {
        this.mMessagingChannel = value;
        return this;
    }

    public String getFieldMonetizationTool() {
        return this.mMonetizationTool;
    }

    public InsightsValue setFieldMonetizationTool(String value) {
        this.mMonetizationTool = value;
        return this;
    }

    public String getFieldRecurringNotificationsEntryPoint() {
        return this.mRecurringNotificationsEntryPoint;
    }

    public InsightsValue setFieldRecurringNotificationsEntryPoint(String value) {
        this.mRecurringNotificationsEntryPoint = value;
        return this;
    }

    public String getFieldRecurringNotificationsFrequency() {
        return this.mRecurringNotificationsFrequency;
    }

    public InsightsValue setFieldRecurringNotificationsFrequency(String value) {
        this.mRecurringNotificationsFrequency = value;
        return this;
    }

    public String getFieldRecurringNotificationsTopic() {
        return this.mRecurringNotificationsTopic;
    }

    public InsightsValue setFieldRecurringNotificationsTopic(String value) {
        this.mRecurringNotificationsTopic = value;
        return this;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public InsightsValue setFieldStartTime(String value) {
        this.mStartTime = value;
        return this;
    }

    public Object getFieldValue() {
        return this.mValue;
    }

    public InsightsValue setFieldValue(Object value) {
        this.mValue = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InsightsValue copyFrom(InsightsValue instance) {
        this.mCampaignId = instance.mCampaignId;
        this.mEarningSource = instance.mEarningSource;
        this.mEndTime = instance.mEndTime;
        this.mEngagementSource = instance.mEngagementSource;
        this.mMessageType = instance.mMessageType;
        this.mMessagingChannel = instance.mMessagingChannel;
        this.mMonetizationTool = instance.mMonetizationTool;
        this.mRecurringNotificationsEntryPoint = instance.mRecurringNotificationsEntryPoint;
        this.mRecurringNotificationsFrequency = instance.mRecurringNotificationsFrequency;
        this.mRecurringNotificationsTopic = instance.mRecurringNotificationsTopic;
        this.mStartTime = instance.mStartTime;
        this.mValue = instance.mValue;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InsightsValue> getParser() {
        return new APIRequest.ResponseParser<InsightsValue>(){

            @Override
            public APINodeList<InsightsValue> parseResponse(String response, APIContext context, APIRequest<InsightsValue> request, String header) throws APIException.MalformedResponseException {
                return InsightsValue.parseResponse(response, context, request, header);
            }
        };
    }
}

