/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogItemChannelsToIntegrityStatus;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.facebook.ads.sdk.OverrideDetails;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class OfflineProductItem
extends APINode {
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="offline_product_item_id")
    private String mOfflineProductItemId = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="visibility")
    private EnumVisibility mVisibility = null;
    protected static Gson gson = null;

    OfflineProductItem() {
    }

    public OfflineProductItem(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OfflineProductItem(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OfflineProductItem fetch() throws APIException {
        OfflineProductItem newInstance = OfflineProductItem.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OfflineProductItem fetchById(Long id, APIContext context) throws APIException {
        return OfflineProductItem.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OfflineProductItem> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OfflineProductItem.fetchByIdAsync(id.toString(), context);
    }

    public static OfflineProductItem fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<OfflineProductItem> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<OfflineProductItem> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OfflineProductItem>(context, "", "/", "GET", OfflineProductItem.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OfflineProductItem>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<OfflineProductItem>(context, "", "/", "GET", OfflineProductItem.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OfflineProductItem loadJSON(String json, APIContext context, String header) {
        OfflineProductItem offlineProductItem = (OfflineProductItem)OfflineProductItem.getGson().fromJson(json, OfflineProductItem.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(offlineProductItem.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        offlineProductItem.context = context;
        offlineProductItem.rawValue = json;
        offlineProductItem.header = header;
        return offlineProductItem;
    }

    public static APINodeList<OfflineProductItem> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OfflineProductItem> offlineProductItems = new APINodeList<OfflineProductItem>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        offlineProductItems.add(OfflineProductItem.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return offlineProductItems;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            offlineProductItems.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        offlineProductItems.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            offlineProductItems.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            offlineProductItems.add(OfflineProductItem.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                offlineProductItems.add(OfflineProductItem.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            offlineProductItems.add(OfflineProductItem.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return offlineProductItems;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        offlineProductItems.add(OfflineProductItem.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return offlineProductItems;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        offlineProductItems.add(OfflineProductItem.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return offlineProductItems;
                }
                offlineProductItems.clear();
                offlineProductItems.add(OfflineProductItem.loadJSON(json, context, header));
                return offlineProductItems;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OfflineProductItem.getGson().toJson((Object)this);
    }

    public APIRequestGetChannelsToIntegrityStatus getChannelsToIntegrityStatus() {
        return new APIRequestGetChannelsToIntegrityStatus(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOverrideDetails getOverrideDetails() {
        return new APIRequestGetOverrideDetails(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldOfflineProductItemId() {
        return this.mOfflineProductItemId;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public EnumVisibility getFieldVisibility() {
        return this.mVisibility;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OfflineProductItem copyFrom(OfflineProductItem instance) {
        this.mApplinks = instance.mApplinks;
        this.mBrand = instance.mBrand;
        this.mCategory = instance.mCategory;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCurrency = instance.mCurrency;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImageUrl = instance.mImageUrl;
        this.mImages = instance.mImages;
        this.mName = instance.mName;
        this.mOfflineProductItemId = instance.mOfflineProductItemId;
        this.mPrice = instance.mPrice;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mUrl = instance.mUrl;
        this.mVisibility = instance.mVisibility;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OfflineProductItem> getParser() {
        return new APIRequest.ResponseParser<OfflineProductItem>(){

            @Override
            public APINodeList<OfflineProductItem> parseResponse(String response, APIContext context, APIRequest<OfflineProductItem> request, String header) throws APIException.MalformedResponseException {
                return OfflineProductItem.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumVisibility {
        VALUE_PUBLISHED("PUBLISHED"),
        VALUE_STAGING("STAGING");

        private String value;

        private EnumVisibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<OfflineProductItem> {
        OfflineProductItem lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"applinks", "brand", "category", "category_specific_fields", "currency", "description", "id", "image_fetch_status", "image_url", "images", "name", "offline_product_item_id", "price", "sanitized_images", "url", "visibility"};

        @Override
        public OfflineProductItem getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OfflineProductItem parseResponse(String response, String header) throws APIException {
            return OfflineProductItem.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public OfflineProductItem execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OfflineProductItem execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<OfflineProductItem> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OfflineProductItem> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, OfflineProductItem>(){

                public OfflineProductItem apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImageUrlField() {
            return this.requestImageUrlField(true);
        }

        public APIRequestGet requestImageUrlField(boolean value) {
            this.requestField("image_url", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOfflineProductItemIdField() {
            return this.requestOfflineProductItemIdField(true);
        }

        public APIRequestGet requestOfflineProductItemIdField(boolean value) {
            this.requestField("offline_product_item_id", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestVisibilityField() {
            return this.requestVisibilityField(true);
        }

        public APIRequestGet requestVisibilityField(boolean value) {
            this.requestField("visibility", value);
            return this;
        }
    }

    public static class APIRequestGetOverrideDetails
    extends APIRequest<OverrideDetails> {
        APINodeList<OverrideDetails> lastResponse = null;
        public static final String[] PARAMS = new String[]{"keys", "type"};
        public static final String[] FIELDS = new String[]{"key", "type", "values"};

        @Override
        public APINodeList<OverrideDetails> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OverrideDetails> parseResponse(String response, String header) throws APIException {
            return OverrideDetails.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<OverrideDetails> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OverrideDetails> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OverrideDetails>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OverrideDetails>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<OverrideDetails>>(){

                public APINodeList<OverrideDetails> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetOverrideDetails(String nodeId, APIContext context) {
            super(context, nodeId, "/override_details", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOverrideDetails setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOverrideDetails setKeys(List<String> keys) {
            this.setParam("keys", keys);
            return this;
        }

        public APIRequestGetOverrideDetails setKeys(String keys) {
            this.setParam("keys", keys);
            return this;
        }

        public APIRequestGetOverrideDetails setType(OverrideDetails.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetOverrideDetails setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetOverrideDetails requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOverrideDetails requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOverrideDetails requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOverrideDetails requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetOverrideDetails requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetOverrideDetails requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetOverrideDetails requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetOverrideDetails requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetOverrideDetails requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }

    public static class APIRequestGetChannelsToIntegrityStatus
    extends APIRequest<CatalogItemChannelsToIntegrityStatus> {
        APINodeList<CatalogItemChannelsToIntegrityStatus> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"channels", "rejection_information"};

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> parseResponse(String response, String header) throws APIException {
            return CatalogItemChannelsToIntegrityStatus.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CatalogItemChannelsToIntegrityStatus>>(){

                public APINodeList<CatalogItemChannelsToIntegrityStatus> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetChannelsToIntegrityStatus(String nodeId, APIContext context) {
            super(context, nodeId, "/channels_to_integrity_status", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetChannelsToIntegrityStatus setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField() {
            return this.requestChannelsField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField(boolean value) {
            this.requestField("channels", value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField() {
            return this.requestRejectionInformationField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField(boolean value) {
            this.requestField("rejection_information", value);
            return this;
        }
    }
}

