/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class PhotoMetadata
extends APINode {
    @SerializedName(value="camera_make")
    private String mCameraMake = null;
    @SerializedName(value="camera_model")
    private String mCameraModel = null;
    @SerializedName(value="datetime_modified")
    private String mDatetimeModified = null;
    @SerializedName(value="datetime_taken")
    private String mDatetimeTaken = null;
    @SerializedName(value="exposure")
    private String mExposure = null;
    @SerializedName(value="focal_length")
    private String mFocalLength = null;
    @SerializedName(value="fstop")
    private String mFstop = null;
    @SerializedName(value="iso_speed")
    private Long mIsoSpeed = null;
    @SerializedName(value="offline_id")
    private String mOfflineId = null;
    @SerializedName(value="orientation")
    private String mOrientation = null;
    @SerializedName(value="original_height")
    private String mOriginalHeight = null;
    @SerializedName(value="original_width")
    private String mOriginalWidth = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static PhotoMetadata loadJSON(String json, APIContext context, String header) {
        PhotoMetadata photoMetadata = (PhotoMetadata)PhotoMetadata.getGson().fromJson(json, PhotoMetadata.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(photoMetadata.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        photoMetadata.context = context;
        photoMetadata.rawValue = json;
        photoMetadata.header = header;
        return photoMetadata;
    }

    public static APINodeList<PhotoMetadata> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PhotoMetadata> photoMetadatas = new APINodeList<PhotoMetadata>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        photoMetadatas.add(PhotoMetadata.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return photoMetadatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            photoMetadatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        photoMetadatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            photoMetadatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            photoMetadatas.add(PhotoMetadata.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                photoMetadatas.add(PhotoMetadata.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            photoMetadatas.add(PhotoMetadata.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return photoMetadatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        photoMetadatas.add(PhotoMetadata.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return photoMetadatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        photoMetadatas.add(PhotoMetadata.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return photoMetadatas;
                }
                photoMetadatas.clear();
                photoMetadatas.add(PhotoMetadata.loadJSON(json, context, header));
                return photoMetadatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PhotoMetadata.getGson().toJson((Object)this);
    }

    public String getFieldCameraMake() {
        return this.mCameraMake;
    }

    public PhotoMetadata setFieldCameraMake(String value) {
        this.mCameraMake = value;
        return this;
    }

    public String getFieldCameraModel() {
        return this.mCameraModel;
    }

    public PhotoMetadata setFieldCameraModel(String value) {
        this.mCameraModel = value;
        return this;
    }

    public String getFieldDatetimeModified() {
        return this.mDatetimeModified;
    }

    public PhotoMetadata setFieldDatetimeModified(String value) {
        this.mDatetimeModified = value;
        return this;
    }

    public String getFieldDatetimeTaken() {
        return this.mDatetimeTaken;
    }

    public PhotoMetadata setFieldDatetimeTaken(String value) {
        this.mDatetimeTaken = value;
        return this;
    }

    public String getFieldExposure() {
        return this.mExposure;
    }

    public PhotoMetadata setFieldExposure(String value) {
        this.mExposure = value;
        return this;
    }

    public String getFieldFocalLength() {
        return this.mFocalLength;
    }

    public PhotoMetadata setFieldFocalLength(String value) {
        this.mFocalLength = value;
        return this;
    }

    public String getFieldFstop() {
        return this.mFstop;
    }

    public PhotoMetadata setFieldFstop(String value) {
        this.mFstop = value;
        return this;
    }

    public Long getFieldIsoSpeed() {
        return this.mIsoSpeed;
    }

    public PhotoMetadata setFieldIsoSpeed(Long value) {
        this.mIsoSpeed = value;
        return this;
    }

    public String getFieldOfflineId() {
        return this.mOfflineId;
    }

    public PhotoMetadata setFieldOfflineId(String value) {
        this.mOfflineId = value;
        return this;
    }

    public String getFieldOrientation() {
        return this.mOrientation;
    }

    public PhotoMetadata setFieldOrientation(String value) {
        this.mOrientation = value;
        return this;
    }

    public String getFieldOriginalHeight() {
        return this.mOriginalHeight;
    }

    public PhotoMetadata setFieldOriginalHeight(String value) {
        this.mOriginalHeight = value;
        return this;
    }

    public String getFieldOriginalWidth() {
        return this.mOriginalWidth;
    }

    public PhotoMetadata setFieldOriginalWidth(String value) {
        this.mOriginalWidth = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PhotoMetadata copyFrom(PhotoMetadata instance) {
        this.mCameraMake = instance.mCameraMake;
        this.mCameraModel = instance.mCameraModel;
        this.mDatetimeModified = instance.mDatetimeModified;
        this.mDatetimeTaken = instance.mDatetimeTaken;
        this.mExposure = instance.mExposure;
        this.mFocalLength = instance.mFocalLength;
        this.mFstop = instance.mFstop;
        this.mIsoSpeed = instance.mIsoSpeed;
        this.mOfflineId = instance.mOfflineId;
        this.mOrientation = instance.mOrientation;
        this.mOriginalHeight = instance.mOriginalHeight;
        this.mOriginalWidth = instance.mOriginalWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PhotoMetadata> getParser() {
        return new APIRequest.ResponseParser<PhotoMetadata>(){

            @Override
            public APINodeList<PhotoMetadata> parseResponse(String response, APIContext context, APIRequest<PhotoMetadata> request, String header) throws APIException.MalformedResponseException {
                return PhotoMetadata.parseResponse(response, context, request, header);
            }
        };
    }
}

