/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class PrivateLiftStudyInstance
extends APINode {
    @SerializedName(value="breakdown_key")
    private String mBreakdownKey = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="feature_list")
    private List<String> mFeatureList = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="issuer_certificate")
    private String mIssuerCertificate = null;
    @SerializedName(value="latest_status_update_time")
    private String mLatestStatusUpdateTime = null;
    @SerializedName(value="run_id")
    private String mRunId = null;
    @SerializedName(value="server_hostnames")
    private List<String> mServerHostnames = null;
    @SerializedName(value="server_ips")
    private List<String> mServerIps = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="tier")
    private String mTier = null;
    protected static Gson gson = null;

    PrivateLiftStudyInstance() {
    }

    public PrivateLiftStudyInstance(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PrivateLiftStudyInstance(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PrivateLiftStudyInstance fetch() throws APIException {
        PrivateLiftStudyInstance newInstance = PrivateLiftStudyInstance.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PrivateLiftStudyInstance fetchById(Long id, APIContext context) throws APIException {
        return PrivateLiftStudyInstance.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PrivateLiftStudyInstance> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PrivateLiftStudyInstance.fetchByIdAsync(id.toString(), context);
    }

    public static PrivateLiftStudyInstance fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PrivateLiftStudyInstance> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PrivateLiftStudyInstance> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PrivateLiftStudyInstance>(context, "", "/", "GET", PrivateLiftStudyInstance.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PrivateLiftStudyInstance>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PrivateLiftStudyInstance>(context, "", "/", "GET", PrivateLiftStudyInstance.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PrivateLiftStudyInstance loadJSON(String json, APIContext context, String header) {
        PrivateLiftStudyInstance privateLiftStudyInstance = (PrivateLiftStudyInstance)PrivateLiftStudyInstance.getGson().fromJson(json, PrivateLiftStudyInstance.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(privateLiftStudyInstance.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        privateLiftStudyInstance.context = context;
        privateLiftStudyInstance.rawValue = json;
        privateLiftStudyInstance.header = header;
        return privateLiftStudyInstance;
    }

    public static APINodeList<PrivateLiftStudyInstance> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PrivateLiftStudyInstance> privateLiftStudyInstances = new APINodeList<PrivateLiftStudyInstance>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        privateLiftStudyInstances.add(PrivateLiftStudyInstance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return privateLiftStudyInstances;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            privateLiftStudyInstances.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        privateLiftStudyInstances.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            privateLiftStudyInstances.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            privateLiftStudyInstances.add(PrivateLiftStudyInstance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                privateLiftStudyInstances.add(PrivateLiftStudyInstance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            privateLiftStudyInstances.add(PrivateLiftStudyInstance.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return privateLiftStudyInstances;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        privateLiftStudyInstances.add(PrivateLiftStudyInstance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return privateLiftStudyInstances;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        privateLiftStudyInstances.add(PrivateLiftStudyInstance.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return privateLiftStudyInstances;
                }
                privateLiftStudyInstances.clear();
                privateLiftStudyInstances.add(PrivateLiftStudyInstance.loadJSON(json, context, header));
                return privateLiftStudyInstances;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PrivateLiftStudyInstance.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBreakdownKey() {
        return this.mBreakdownKey;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public List<String> getFieldFeatureList() {
        return this.mFeatureList;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIssuerCertificate() {
        return this.mIssuerCertificate;
    }

    public String getFieldLatestStatusUpdateTime() {
        return this.mLatestStatusUpdateTime;
    }

    public String getFieldRunId() {
        return this.mRunId;
    }

    public List<String> getFieldServerHostnames() {
        return this.mServerHostnames;
    }

    public List<String> getFieldServerIps() {
        return this.mServerIps;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldTier() {
        return this.mTier;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PrivateLiftStudyInstance copyFrom(PrivateLiftStudyInstance instance) {
        this.mBreakdownKey = instance.mBreakdownKey;
        this.mCreatedTime = instance.mCreatedTime;
        this.mFeatureList = instance.mFeatureList;
        this.mId = instance.mId;
        this.mIssuerCertificate = instance.mIssuerCertificate;
        this.mLatestStatusUpdateTime = instance.mLatestStatusUpdateTime;
        this.mRunId = instance.mRunId;
        this.mServerHostnames = instance.mServerHostnames;
        this.mServerIps = instance.mServerIps;
        this.mStatus = instance.mStatus;
        this.mTier = instance.mTier;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PrivateLiftStudyInstance> getParser() {
        return new APIRequest.ResponseParser<PrivateLiftStudyInstance>(){

            @Override
            public APINodeList<PrivateLiftStudyInstance> parseResponse(String response, APIContext context, APIRequest<PrivateLiftStudyInstance> request, String header) throws APIException.MalformedResponseException {
                return PrivateLiftStudyInstance.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumOperation {
        VALUE_AGGREGATE("AGGREGATE"),
        VALUE_CANCEL("CANCEL"),
        VALUE_COMPUTE("COMPUTE"),
        VALUE_ID_MATCH("ID_MATCH"),
        VALUE_NEXT("NEXT"),
        VALUE_NONE("NONE");

        private String value;

        private EnumOperation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<PrivateLiftStudyInstance> {
        PrivateLiftStudyInstance lastResponse = null;
        public static final String[] PARAMS = new String[]{"operation", "run_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PrivateLiftStudyInstance getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PrivateLiftStudyInstance parseResponse(String response, String header) throws APIException {
            return PrivateLiftStudyInstance.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PrivateLiftStudyInstance execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PrivateLiftStudyInstance execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PrivateLiftStudyInstance> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PrivateLiftStudyInstance> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PrivateLiftStudyInstance>(){

                public PrivateLiftStudyInstance apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setOperation(EnumOperation operation) {
            this.setParam("operation", (Object)operation);
            return this;
        }

        public APIRequestUpdate setOperation(String operation) {
            this.setParam("operation", operation);
            return this;
        }

        public APIRequestUpdate setRunId(String runId) {
            this.setParam("run_id", runId);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<PrivateLiftStudyInstance> {
        PrivateLiftStudyInstance lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"breakdown_key", "created_time", "feature_list", "id", "issuer_certificate", "latest_status_update_time", "run_id", "server_hostnames", "server_ips", "status", "tier"};

        @Override
        public PrivateLiftStudyInstance getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PrivateLiftStudyInstance parseResponse(String response, String header) throws APIException {
            return PrivateLiftStudyInstance.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PrivateLiftStudyInstance execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PrivateLiftStudyInstance execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PrivateLiftStudyInstance> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PrivateLiftStudyInstance> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PrivateLiftStudyInstance>(){

                public PrivateLiftStudyInstance apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBreakdownKeyField() {
            return this.requestBreakdownKeyField(true);
        }

        public APIRequestGet requestBreakdownKeyField(boolean value) {
            this.requestField("breakdown_key", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestFeatureListField() {
            return this.requestFeatureListField(true);
        }

        public APIRequestGet requestFeatureListField(boolean value) {
            this.requestField("feature_list", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIssuerCertificateField() {
            return this.requestIssuerCertificateField(true);
        }

        public APIRequestGet requestIssuerCertificateField(boolean value) {
            this.requestField("issuer_certificate", value);
            return this;
        }

        public APIRequestGet requestLatestStatusUpdateTimeField() {
            return this.requestLatestStatusUpdateTimeField(true);
        }

        public APIRequestGet requestLatestStatusUpdateTimeField(boolean value) {
            this.requestField("latest_status_update_time", value);
            return this;
        }

        public APIRequestGet requestRunIdField() {
            return this.requestRunIdField(true);
        }

        public APIRequestGet requestRunIdField(boolean value) {
            this.requestField("run_id", value);
            return this;
        }

        public APIRequestGet requestServerHostnamesField() {
            return this.requestServerHostnamesField(true);
        }

        public APIRequestGet requestServerHostnamesField(boolean value) {
            this.requestField("server_hostnames", value);
            return this;
        }

        public APIRequestGet requestServerIpsField() {
            return this.requestServerIpsField(true);
        }

        public APIRequestGet requestServerIpsField(boolean value) {
            this.requestField("server_ips", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTierField() {
            return this.requestTierField(true);
        }

        public APIRequestGet requestTierField(boolean value) {
            this.requestField("tier", value);
            return this;
        }
    }
}

