/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ProfilePictureSource
extends APINode {
    @SerializedName(value="bottom")
    private Long mBottom = null;
    @SerializedName(value="cache_key")
    private String mCacheKey = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="is_silhouette")
    private Boolean mIsSilhouette = null;
    @SerializedName(value="left")
    private Long mLeft = null;
    @SerializedName(value="right")
    private Long mRight = null;
    @SerializedName(value="top")
    private Long mTop = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ProfilePictureSource loadJSON(String json, APIContext context, String header) {
        ProfilePictureSource profilePictureSource = (ProfilePictureSource)ProfilePictureSource.getGson().fromJson(json, ProfilePictureSource.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(profilePictureSource.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        profilePictureSource.context = context;
        profilePictureSource.rawValue = json;
        profilePictureSource.header = header;
        return profilePictureSource;
    }

    public static APINodeList<ProfilePictureSource> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProfilePictureSource> profilePictureSources = new APINodeList<ProfilePictureSource>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        profilePictureSources.add(ProfilePictureSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return profilePictureSources;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            profilePictureSources.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        profilePictureSources.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            profilePictureSources.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            profilePictureSources.add(ProfilePictureSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                profilePictureSources.add(ProfilePictureSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            profilePictureSources.add(ProfilePictureSource.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return profilePictureSources;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        profilePictureSources.add(ProfilePictureSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return profilePictureSources;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        profilePictureSources.add(ProfilePictureSource.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return profilePictureSources;
                }
                profilePictureSources.clear();
                profilePictureSources.add(ProfilePictureSource.loadJSON(json, context, header));
                return profilePictureSources;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProfilePictureSource.getGson().toJson((Object)this);
    }

    public Long getFieldBottom() {
        return this.mBottom;
    }

    public ProfilePictureSource setFieldBottom(Long value) {
        this.mBottom = value;
        return this;
    }

    public String getFieldCacheKey() {
        return this.mCacheKey;
    }

    public ProfilePictureSource setFieldCacheKey(String value) {
        this.mCacheKey = value;
        return this;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public ProfilePictureSource setFieldHeight(Long value) {
        this.mHeight = value;
        return this;
    }

    public Boolean getFieldIsSilhouette() {
        return this.mIsSilhouette;
    }

    public ProfilePictureSource setFieldIsSilhouette(Boolean value) {
        this.mIsSilhouette = value;
        return this;
    }

    public Long getFieldLeft() {
        return this.mLeft;
    }

    public ProfilePictureSource setFieldLeft(Long value) {
        this.mLeft = value;
        return this;
    }

    public Long getFieldRight() {
        return this.mRight;
    }

    public ProfilePictureSource setFieldRight(Long value) {
        this.mRight = value;
        return this;
    }

    public Long getFieldTop() {
        return this.mTop;
    }

    public ProfilePictureSource setFieldTop(Long value) {
        this.mTop = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public ProfilePictureSource setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    public ProfilePictureSource setFieldWidth(Long value) {
        this.mWidth = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProfilePictureSource copyFrom(ProfilePictureSource instance) {
        this.mBottom = instance.mBottom;
        this.mCacheKey = instance.mCacheKey;
        this.mHeight = instance.mHeight;
        this.mIsSilhouette = instance.mIsSilhouette;
        this.mLeft = instance.mLeft;
        this.mRight = instance.mRight;
        this.mTop = instance.mTop;
        this.mUrl = instance.mUrl;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProfilePictureSource> getParser() {
        return new APIRequest.ResponseParser<ProfilePictureSource>(){

            @Override
            public APINodeList<ProfilePictureSource> parseResponse(String response, APIContext context, APIRequest<ProfilePictureSource> request, String header) throws APIException.MalformedResponseException {
                return ProfilePictureSource.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumType {
        VALUE_ALBUM("album"),
        VALUE_SMALL("small"),
        VALUE_THUMBNAIL("thumbnail");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

