/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ThirdPartyPartnerPanelScheduled
extends APINode {
    @SerializedName(value="adentities_ids")
    private List<String> mAdentitiesIds = null;
    @SerializedName(value="cadence")
    private String mCadence = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="owner_instance_id")
    private String mOwnerInstanceId = null;
    @SerializedName(value="owner_panel_id")
    private String mOwnerPanelId = null;
    @SerializedName(value="owner_panel_name")
    private String mOwnerPanelName = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="study_type")
    private EnumStudyType mStudyType = null;
    protected static Gson gson = null;

    ThirdPartyPartnerPanelScheduled() {
    }

    public ThirdPartyPartnerPanelScheduled(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ThirdPartyPartnerPanelScheduled(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ThirdPartyPartnerPanelScheduled fetch() throws APIException {
        ThirdPartyPartnerPanelScheduled newInstance = ThirdPartyPartnerPanelScheduled.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ThirdPartyPartnerPanelScheduled fetchById(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerPanelScheduled.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ThirdPartyPartnerPanelScheduled> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerPanelScheduled.fetchByIdAsync(id.toString(), context);
    }

    public static ThirdPartyPartnerPanelScheduled fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ThirdPartyPartnerPanelScheduled> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ThirdPartyPartnerPanelScheduled> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ThirdPartyPartnerPanelScheduled>(context, "", "/", "GET", ThirdPartyPartnerPanelScheduled.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ThirdPartyPartnerPanelScheduled>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ThirdPartyPartnerPanelScheduled>(context, "", "/", "GET", ThirdPartyPartnerPanelScheduled.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ThirdPartyPartnerPanelScheduled loadJSON(String json, APIContext context, String header) {
        ThirdPartyPartnerPanelScheduled thirdPartyPartnerPanelScheduled = (ThirdPartyPartnerPanelScheduled)ThirdPartyPartnerPanelScheduled.getGson().fromJson(json, ThirdPartyPartnerPanelScheduled.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(thirdPartyPartnerPanelScheduled.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        thirdPartyPartnerPanelScheduled.context = context;
        thirdPartyPartnerPanelScheduled.rawValue = json;
        thirdPartyPartnerPanelScheduled.header = header;
        return thirdPartyPartnerPanelScheduled;
    }

    public static APINodeList<ThirdPartyPartnerPanelScheduled> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ThirdPartyPartnerPanelScheduled> thirdPartyPartnerPanelScheduleds = new APINodeList<ThirdPartyPartnerPanelScheduled>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        thirdPartyPartnerPanelScheduleds.add(ThirdPartyPartnerPanelScheduled.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return thirdPartyPartnerPanelScheduleds;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            thirdPartyPartnerPanelScheduleds.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        thirdPartyPartnerPanelScheduleds.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            thirdPartyPartnerPanelScheduleds.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            thirdPartyPartnerPanelScheduleds.add(ThirdPartyPartnerPanelScheduled.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                thirdPartyPartnerPanelScheduleds.add(ThirdPartyPartnerPanelScheduled.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            thirdPartyPartnerPanelScheduleds.add(ThirdPartyPartnerPanelScheduled.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return thirdPartyPartnerPanelScheduleds;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        thirdPartyPartnerPanelScheduleds.add(ThirdPartyPartnerPanelScheduled.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return thirdPartyPartnerPanelScheduleds;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        thirdPartyPartnerPanelScheduleds.add(ThirdPartyPartnerPanelScheduled.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return thirdPartyPartnerPanelScheduleds;
                }
                thirdPartyPartnerPanelScheduleds.clear();
                thirdPartyPartnerPanelScheduleds.add(ThirdPartyPartnerPanelScheduled.loadJSON(json, context, header));
                return thirdPartyPartnerPanelScheduleds;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ThirdPartyPartnerPanelScheduled.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAdentitiesIds() {
        return this.mAdentitiesIds;
    }

    public String getFieldCadence() {
        return this.mCadence;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public String getFieldOwnerInstanceId() {
        return this.mOwnerInstanceId;
    }

    public String getFieldOwnerPanelId() {
        return this.mOwnerPanelId;
    }

    public String getFieldOwnerPanelName() {
        return this.mOwnerPanelName;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public EnumStudyType getFieldStudyType() {
        return this.mStudyType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ThirdPartyPartnerPanelScheduled copyFrom(ThirdPartyPartnerPanelScheduled instance) {
        this.mAdentitiesIds = instance.mAdentitiesIds;
        this.mCadence = instance.mCadence;
        this.mCountry = instance.mCountry;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mEndTime = instance.mEndTime;
        this.mId = instance.mId;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOwnerInstanceId = instance.mOwnerInstanceId;
        this.mOwnerPanelId = instance.mOwnerPanelId;
        this.mOwnerPanelName = instance.mOwnerPanelName;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mStudyType = instance.mStudyType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ThirdPartyPartnerPanelScheduled> getParser() {
        return new APIRequest.ResponseParser<ThirdPartyPartnerPanelScheduled>(){

            @Override
            public APINodeList<ThirdPartyPartnerPanelScheduled> parseResponse(String response, APIContext context, APIRequest<ThirdPartyPartnerPanelScheduled> request, String header) throws APIException.MalformedResponseException {
                return ThirdPartyPartnerPanelScheduled.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStudyType {
        VALUE_BRAND_LIFT("BRAND_LIFT"),
        VALUE_PANEL_SALES_ATTRIBUTION("PANEL_SALES_ATTRIBUTION"),
        VALUE_REACH("REACH");

        private String value;

        private EnumStudyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumStatus {
        VALUE_CANCELLED("CANCELLED"),
        VALUE_CREATED("CREATED"),
        VALUE_FINISHED("FINISHED"),
        VALUE_ONGOING("ONGOING");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ThirdPartyPartnerPanelScheduled> {
        ThirdPartyPartnerPanelScheduled lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"adentities_ids", "cadence", "country", "created_time", "description", "end_time", "id", "modified_time", "owner_instance_id", "owner_panel_id", "owner_panel_name", "start_time", "status", "study_type"};

        @Override
        public ThirdPartyPartnerPanelScheduled getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ThirdPartyPartnerPanelScheduled parseResponse(String response, String header) throws APIException {
            return ThirdPartyPartnerPanelScheduled.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ThirdPartyPartnerPanelScheduled execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ThirdPartyPartnerPanelScheduled execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ThirdPartyPartnerPanelScheduled> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ThirdPartyPartnerPanelScheduled> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ThirdPartyPartnerPanelScheduled>(){

                public ThirdPartyPartnerPanelScheduled apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdentitiesIdsField() {
            return this.requestAdentitiesIdsField(true);
        }

        public APIRequestGet requestAdentitiesIdsField(boolean value) {
            this.requestField("adentities_ids", value);
            return this;
        }

        public APIRequestGet requestCadenceField() {
            return this.requestCadenceField(true);
        }

        public APIRequestGet requestCadenceField(boolean value) {
            this.requestField("cadence", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestModifiedTimeField() {
            return this.requestModifiedTimeField(true);
        }

        public APIRequestGet requestModifiedTimeField(boolean value) {
            this.requestField("modified_time", value);
            return this;
        }

        public APIRequestGet requestOwnerInstanceIdField() {
            return this.requestOwnerInstanceIdField(true);
        }

        public APIRequestGet requestOwnerInstanceIdField(boolean value) {
            this.requestField("owner_instance_id", value);
            return this;
        }

        public APIRequestGet requestOwnerPanelIdField() {
            return this.requestOwnerPanelIdField(true);
        }

        public APIRequestGet requestOwnerPanelIdField(boolean value) {
            this.requestField("owner_panel_id", value);
            return this;
        }

        public APIRequestGet requestOwnerPanelNameField() {
            return this.requestOwnerPanelNameField(true);
        }

        public APIRequestGet requestOwnerPanelNameField(boolean value) {
            this.requestField("owner_panel_name", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStudyTypeField() {
            return this.requestStudyTypeField(true);
        }

        public APIRequestGet requestStudyTypeField(boolean value) {
            this.requestField("study_type", value);
            return this;
        }
    }
}

