/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.http;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.config.ConstantValueInputImpl;
import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.config.el.CompositeExpressionInputBuilder;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.PathItem;
import com.emc.mongoose.base.item.TokenItem;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.storage.driver.coop.netty.NettyStorageDriverBase;
import com.emc.mongoose.storage.driver.coop.netty.http.HttpStorageDriver;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.confuse.Config;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public abstract class HttpStorageDriverBase<I extends Item, O extends Operation<I>>
extends NettyStorageDriverBase<I, O>
implements HttpStorageDriver<I, O> {
    private static final String CLS_NAME = HttpStorageDriverBase.class.getSimpleName();
    private static final Function<String, Input<String>> EXPR_INPUT_FUNC = expr -> CompositeExpressionInputBuilder.newInstance().expression(expr).build();
    private final Map<String, Input<String>> headerNameInputs = new ConcurrentHashMap<String, Input<String>>();
    private final Map<String, Input<String>> headerValueInputs = new ConcurrentHashMap<String, Input<String>>();
    protected final HttpHeaders sharedHeaders = new DefaultHttpHeaders();
    protected final Map<String, String> dynamicHeaders = new HashMap<String, String>();
    private final Input<String> uriQueryInput;
    protected final ChannelFutureListener httpReqSentCallback = this::sendHttpRequestComplete;
    protected final boolean readMetadataOnly;
    private static final ThreadLocal<StringBuilder> THR_LOC_RANGES_BUILDER = ThreadLocal.withInitial(StringBuilder::new);

    protected HttpStorageDriverBase(String testStepId, DataInput itemDataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException, InterruptedException {
        super(testStepId, itemDataInput, storageConfig, verifyFlag, batchSize);
        Map uriArgs;
        String uriQueryExpr;
        Config httpConfig = storageConfig.configVal("net-http");
        Map headersMap = httpConfig.mapVal("headers");
        for (Map.Entry header : headersMap.entrySet()) {
            String headerKey = (String)header.getKey();
            String headerValue = (String)header.getValue();
            if (headerKey.contains("#{") || headerKey.contains("${") || headerKey.contains("%{") || headerValue.contains("#{") || headerValue.contains("${") || headerValue.contains("%{")) {
                this.dynamicHeaders.put(headerKey, headerValue);
                continue;
            }
            this.sharedHeaders.add(headerKey, (Object)headerValue);
        }
        this.readMetadataOnly = httpConfig.boolVal("read-metadata-only");
        if (this.readMetadataOnly) {
            Loggers.MSG.info("Reading metadata only (HEAD requests)");
        }
        this.uriQueryInput = (uriQueryExpr = (uriArgs = httpConfig.mapVal("uri-args")).entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"))).length() > 0 ? EXPR_INPUT_FUNC.apply("?" + uriQueryExpr) : new ConstantValueInputImpl((Object)"");
    }

    protected FullHttpResponse executeHttpRequest(FullHttpRequest request) throws InterruptedException, ConnectException {
        FullHttpResponse resp;
        ThreadContext.put((String)"step_id", (String)this.stepId);
        ThreadContext.put((String)"class_name", (String)CLS_NAME);
        try (Channel channel = this.getUnpooledConnection(this.storageNodeAddrs[0], this.storageNodePort);){
            ChannelPipeline pipeline = channel.pipeline();
            Loggers.MSG.debug("{}: execute the HTTP request using the channel {} w/ pipeline: {}", (Object)this.stepId, (Object)channel.hashCode(), (Object)pipeline);
            pipeline.removeLast();
            final SynchronousQueue fullRespSync = new SynchronousQueue();
            pipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
            pipeline.addLast(new SimpleChannelInboundHandler<HttpObject>(){

                @Override
                protected final void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                    if (msg instanceof FullHttpResponse) {
                        fullRespSync.put(((FullHttpResponse)msg).retain());
                    }
                }
            });
            channel.writeAndFlush(request).sync();
            resp = (FullHttpResponse)fullRespSync.poll(this.netTimeoutMilliSec, TimeUnit.MILLISECONDS);
            if (null == resp) {
                Loggers.MSG.warn("{}: Response timeout \n Request: {}", (Object)this.stepId, (Object)request);
            }
        }
        return resp;
    }

    protected void appendHandlers(Channel channel) {
        super.appendHandlers(channel);
        channel.pipeline().addLast(new HttpClientCodec(1024, 2048, 8192, true)).addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
    }

    protected HttpRequest httpRequest(O op, String nodeAddr) throws URISyntaxException {
        String uriPath;
        HttpMethod httpMethod;
        Item item = op.item();
        OpType opType = op.type();
        String srcPath = op.srcPath();
        if (item instanceof DataItem) {
            httpMethod = this.dataHttpMethod(opType);
            uriPath = this.dataUriPath(item, srcPath, op.dstPath(), opType);
        } else if (item instanceof TokenItem) {
            httpMethod = this.tokenHttpMethod(opType);
            uriPath = this.tokenUriPath(item, srcPath, op.dstPath(), opType);
        } else if (item instanceof PathItem) {
            httpMethod = this.pathHttpMethod(opType);
            uriPath = this.pathUriPath(item, srcPath, op.dstPath(), opType);
        } else {
            throw new AssertionError((Object)("Unsupported item class: " + item.getClass().getName()));
        }
        String uriQuery = this.uriQuery();
        String uri = uriQuery == null || uriQuery.isEmpty() ? uriPath : uriPath + uriQuery;
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        if (nodeAddr != null) {
            ((HttpHeaders)httpHeaders).set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        }
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri, httpHeaders);
        switch (opType) {
            case CREATE: {
                if (srcPath == null || srcPath.isEmpty()) {
                    if (item instanceof DataItem) {
                        try {
                            ((HttpHeaders)httpHeaders).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)((DataItem)item).size());
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    ((HttpHeaders)httpHeaders).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
                    break;
                }
                this.applyCopyHeaders(httpHeaders, this.dataUriPath(item, srcPath, null, opType));
                ((HttpHeaders)httpHeaders).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
                break;
            }
            case READ: {
                ((HttpHeaders)httpHeaders).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
                if (!(op instanceof DataOperation)) break;
                this.applyRangesHeaders(httpHeaders, (DataOperation)op);
                break;
            }
            case UPDATE: {
                DataOperation dataOp = (DataOperation)op;
                ((HttpHeaders)httpHeaders).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)dataOp.markedRangesSize());
                this.applyRangesHeaders(httpHeaders, dataOp);
                break;
            }
            case DELETE: {
                ((HttpHeaders)httpHeaders).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            }
        }
        this.applyMetaDataHeaders(httpHeaders);
        this.applyDynamicHeaders(httpHeaders);
        this.applySharedHeaders(httpHeaders);
        this.applyAuthHeaders(httpHeaders, httpMethod, uriPath, op.credential());
        return httpRequest;
    }

    protected HttpMethod dataHttpMethod(OpType opType) {
        switch (opType) {
            case READ: {
                return this.readMetadataOnly ? HttpMethod.HEAD : HttpMethod.GET;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
        }
        return HttpMethod.PUT;
    }

    protected abstract HttpMethod tokenHttpMethod(OpType var1);

    protected abstract HttpMethod pathHttpMethod(OpType var1);

    protected String dataUriPath(I item, String srcPath, String dstPath, OpType opType) {
        Object itemPath = dstPath != null ? (dstPath.startsWith("/") ? dstPath : "/" + dstPath) : (srcPath != null ? (srcPath.startsWith("/") ? srcPath : "/" + srcPath) : null);
        String itemNameRaw = item.name();
        Object itemName = itemNameRaw.startsWith("/") ? itemNameRaw : "/" + itemNameRaw;
        return itemPath == null || ((String)itemName).startsWith((String)itemPath) ? itemName : (String)itemPath + (String)itemName;
    }

    protected abstract String tokenUriPath(I var1, String var2, String var3, OpType var4);

    protected abstract String pathUriPath(I var1, String var2, String var3, OpType var4);

    protected void applyRangesHeaders(HttpHeaders httpHeaders, DataOperation dataOp) {
        long baseItemSize;
        try {
            baseItemSize = dataOp.item().size();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        List fixedRanges = dataOp.fixedRanges();
        StringBuilder strb = THR_LOC_RANGES_BUILDER.get();
        strb.setLength(0);
        if (fixedRanges == null || fixedRanges.isEmpty()) {
            int i;
            BitSet[] rangesMaskPair = dataOp.markedRangesMaskPair();
            if (rangesMaskPair[0].isEmpty() && rangesMaskPair[1].isEmpty()) {
                return;
            }
            for (i = 0; i < DataItem.rangeCount((long)baseItemSize); ++i) {
                if (!rangesMaskPair[0].get(i)) continue;
                if (strb.length() > 0) {
                    strb.append(',');
                }
                strb.append(DataItem.rangeOffset((int)i)).append('-').append(Math.min(DataItem.rangeOffset((int)(i + 1)), baseItemSize) - 1L);
            }
            for (i = 0; i < DataItem.rangeCount((long)baseItemSize); ++i) {
                if (!rangesMaskPair[1].get(i)) continue;
                if (strb.length() > 0) {
                    strb.append(',');
                }
                strb.append(DataItem.rangeOffset((int)i)).append('-').append(Math.min(DataItem.rangeOffset((int)(i + 1)), baseItemSize) - 1L);
            }
        } else {
            HttpStorageDriverBase.rangeListToStringBuff(fixedRanges, baseItemSize, strb);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.RANGE, (Object)("bytes=" + strb.toString()));
    }

    protected static void rangeListToStringBuff(List<Range> ranges, long baseLength, StringBuilder dstBuff) {
        for (int i = 0; i < ranges.size(); ++i) {
            Range nextFixedRange = ranges.get(i);
            long nextRangeSize = nextFixedRange.getSize();
            if (i > 0) {
                dstBuff.append(',');
            }
            if (nextRangeSize == -1L) {
                dstBuff.append(nextFixedRange.toString());
                continue;
            }
            dstBuff.append(baseLength).append("-");
        }
    }

    protected void applySharedHeaders(HttpHeaders httpHeaders) {
        for (Map.Entry<String, String> sharedHeader : this.sharedHeaders) {
            httpHeaders.add(sharedHeader.getKey(), (Object)sharedHeader.getValue());
        }
    }

    protected void applyDynamicHeaders(HttpHeaders httpHeaders) {
        for (Map.Entry<String, String> nextHeader : this.dynamicHeaders.entrySet()) {
            String headerName = nextHeader.getKey();
            Input<String> headerNameInput = this.headerNameInputs.computeIfAbsent(headerName, EXPR_INPUT_FUNC);
            if (headerNameInput == null) continue;
            headerName = (String)headerNameInput.get();
            String headerValue = nextHeader.getValue();
            Input<String> headerValueInput = this.headerValueInputs.computeIfAbsent(headerValue, EXPR_INPUT_FUNC);
            if (headerValueInput == null) continue;
            headerValue = (String)headerValueInput.get();
            httpHeaders.set(headerName, (Object)headerValue);
        }
    }

    protected final String uriQuery() {
        return (String)this.uriQueryInput.get();
    }

    protected abstract void applyMetaDataHeaders(HttpHeaders var1);

    protected abstract void applyAuthHeaders(HttpHeaders var1, HttpMethod var2, String var3, Credential var4);

    protected abstract void applyCopyHeaders(HttpHeaders var1, String var2) throws URISyntaxException;

    protected final void sendRequest(Channel channel, O op) {
        block7: {
            String nodeAddr = op.nodeAddr();
            try {
                HttpRequest httpRequest = this.httpRequest(op, nodeAddr);
                if (channel == null) {
                    return;
                }
                channel.write(httpRequest).addListener(this.httpReqSentCallback);
                if (Loggers.MSG.isTraceEnabled()) {
                    Loggers.MSG.trace("{} >>>> {} {}", (Object)op.hashCode(), (Object)httpRequest.method(), (Object)httpRequest.uri());
                }
                if (!(httpRequest instanceof FullHttpRequest)) {
                    this.sendRequestData(channel, (Operation)op);
                }
            }
            catch (IOException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to write the data", (Object[])new Object[0]);
            }
            catch (URISyntaxException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to build the request URI", (Object[])new Object[0]);
            }
            catch (Throwable e) {
                Exceptions.throwUncheckedIfInterrupted((Throwable)e);
                if (this.isStopped() || this.isClosed()) break block7;
                LogUtil.trace((Logger)Loggers.ERR, (Level)Level.ERROR, (Throwable)e, (String)"Send HTTP request failure", (Object[])new Object[0]);
            }
        }
        channel.write(LastHttpContent.EMPTY_LAST_CONTENT).addListener(this.reqSentCallback);
        channel.flush();
    }

    void sendHttpRequestComplete(ChannelFuture future) {
        try {
            future.get(1L, TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            Throwable cause = e.getCause();
            LogUtil.trace((Logger)Loggers.ERR, (Level)Level.WARN, (Throwable)cause, (String)"Failed to send the request", (Object[])new Object[0]);
            Operation op = (Operation)future.channel().attr(ATTR_KEY_OPERATION).get();
            op.status(Operation.Status.FAIL_IO);
            this.complete(future.channel(), op);
        }
        catch (InterruptedException e) {
            com.github.akurilov.commons.lang.Exceptions.throwUnchecked((Throwable)e);
        }
    }

    protected void doClose() throws IOException {
        super.doClose();
        try {
            this.uriQueryInput.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sharedHeaders.clear();
        this.dynamicHeaders.clear();
        this.headerNameInputs.values().forEach(headerNameInput -> {
            try {
                headerNameInput.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.headerNameInputs.clear();
        this.headerValueInputs.values().forEach(headerValueInput -> {
            try {
                headerValueInput.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.headerValueInputs.clear();
    }
}

