/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.asn1.tsp;

import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1Encodable;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1EncodableVector;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1Object;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1Primitive;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1Sequence;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1TaggedObject;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.DERSequence;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.DERTaggedObject;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.cms.Attributes;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.cms.ContentInfo;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.cms.SignedData;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.tsp.PartialHashtree;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.tsp.TSTInfo;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ArchiveTimeStamp
extends ASN1Object {
    private AlgorithmIdentifier digestAlgorithm;
    private Attributes attributes;
    private ASN1Sequence reducedHashTree;
    private ContentInfo timeStamp;

    public static ArchiveTimeStamp getInstance(Object object) {
        if (object instanceof ArchiveTimeStamp) {
            return (ArchiveTimeStamp)object;
        }
        if (object != null) {
            return new ArchiveTimeStamp(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ArchiveTimeStamp(AlgorithmIdentifier algorithmIdentifier, PartialHashtree[] partialHashtreeArray, ContentInfo contentInfo) {
        this.digestAlgorithm = algorithmIdentifier;
        this.reducedHashTree = new DERSequence(partialHashtreeArray);
        this.timeStamp = contentInfo;
    }

    public ArchiveTimeStamp(AlgorithmIdentifier algorithmIdentifier, Attributes attributes, PartialHashtree[] partialHashtreeArray, ContentInfo contentInfo) {
        this.digestAlgorithm = algorithmIdentifier;
        this.attributes = attributes;
        this.reducedHashTree = new DERSequence(partialHashtreeArray);
        this.timeStamp = contentInfo;
    }

    public ArchiveTimeStamp(ContentInfo contentInfo) {
        this.timeStamp = contentInfo;
    }

    private ArchiveTimeStamp(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 4) {
            throw new IllegalArgumentException("wrong sequence size in constructor: " + aSN1Sequence.size());
        }
        block5: for (int i = 0; i < aSN1Sequence.size() - 1; ++i) {
            ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(i);
            if (!(aSN1Encodable instanceof ASN1TaggedObject)) continue;
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.digestAlgorithm = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 1: {
                    this.attributes = Attributes.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 2: {
                    this.reducedHashTree = ASN1Sequence.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("invalid tag no in constructor: " + aSN1TaggedObject.getTagNo());
                }
            }
        }
        this.timeStamp = ContentInfo.getInstance(aSN1Sequence.getObjectAt(aSN1Sequence.size() - 1));
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        if (this.digestAlgorithm != null) {
            return this.digestAlgorithm;
        }
        if (this.timeStamp.getContentType().equals(CMSObjectIdentifiers.signedData)) {
            SignedData signedData = SignedData.getInstance(this.timeStamp.getContent());
            if (signedData.getEncapContentInfo().getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
                TSTInfo tSTInfo = TSTInfo.getInstance(signedData.getEncapContentInfo());
                return tSTInfo.getMessageImprint().getHashAlgorithm();
            }
            throw new IllegalStateException("cannot parse time stamp");
        }
        throw new IllegalStateException("cannot identify algorithm identifier for digest");
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public PartialHashtree[] getReducedHashTree() {
        if (this.reducedHashTree == null) {
            return null;
        }
        PartialHashtree[] partialHashtreeArray = new PartialHashtree[this.reducedHashTree.size()];
        for (int i = 0; i != partialHashtreeArray.length; ++i) {
            partialHashtreeArray[i] = PartialHashtree.getInstance(this.reducedHashTree.getObjectAt(i));
        }
        return partialHashtreeArray;
    }

    public ContentInfo getTimeStamp() {
        return this.timeStamp;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        if (this.digestAlgorithm != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.digestAlgorithm));
        }
        if (this.attributes != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.attributes));
        }
        if (this.reducedHashTree != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.reducedHashTree));
        }
        aSN1EncodableVector.add(this.timeStamp);
        return new DERSequence(aSN1EncodableVector);
    }
}

