/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.crypto.util;

import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.CipherKeyGenerator;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.KeyGenerationParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.generators.DESKeyGenerator;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.generators.DESedeKeyGenerator;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import java.security.SecureRandom;

public class CipherKeyGeneratorFactory {
    private CipherKeyGeneratorFactory() {
    }

    public static CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, SecureRandom secureRandom) throws IllegalArgumentException {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_CBC.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_CBC.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 256);
        }
        if (NISTObjectIdentifiers.id_aes128_GCM.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_GCM.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_GCM.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 256);
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(aSN1ObjectIdentifier)) {
            DESedeKeyGenerator dESedeKeyGenerator = new DESedeKeyGenerator();
            dESedeKeyGenerator.init(new KeyGenerationParameters(secureRandom, 192));
            return dESedeKeyGenerator;
        }
        if (NTTObjectIdentifiers.id_camellia128_cbc.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (NTTObjectIdentifiers.id_camellia192_cbc.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 192);
        }
        if (NTTObjectIdentifiers.id_camellia256_cbc.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 256);
        }
        if (KISAObjectIdentifiers.id_seedCBC.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (AlgorithmIdentifierFactory.CAST5_CBC.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (OIWObjectIdentifiers.desCBC.equals(aSN1ObjectIdentifier)) {
            DESKeyGenerator dESKeyGenerator = new DESKeyGenerator();
            dESKeyGenerator.init(new KeyGenerationParameters(secureRandom, 64));
            return dESKeyGenerator;
        }
        if (PKCSObjectIdentifiers.rc4.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (PKCSObjectIdentifiers.RC2_CBC.equals(aSN1ObjectIdentifier)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        throw new IllegalArgumentException("cannot recognise cipher: " + aSN1ObjectIdentifier);
    }

    private static CipherKeyGenerator createCipherKeyGenerator(SecureRandom secureRandom, int n) {
        CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
        cipherKeyGenerator.init(new KeyGenerationParameters(secureRandom, n));
        return cipherKeyGenerator;
    }
}

