/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1;

import hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1.CommonFunction;
import hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1.HashUtils;
import hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1.Pack;
import hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1.Polynomial;
import hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1.PolynomialHeuristic;
import hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1.PolynomialProvablySecure;
import hadoopcryptoledger.shade.org.bouncycastle.pqc.crypto.qteslarnd1.Sample;
import java.security.SecureRandom;

public class QTESLA {
    private static void hashFunction(byte[] byArray, int n, int[] nArray, byte[] byArray2, int n2, int n3, int n4, int n5) {
        byte[] byArray3 = new byte[n3 + 64];
        for (int i = 0; i < n3; ++i) {
            int n6 = n5 / 2 - nArray[i] >> 31;
            nArray[i] = nArray[i] - n5 & n6 | nArray[i] & ~n6;
            int n7 = nArray[i] & (1 << n4) - 1;
            n6 = (1 << n4 - 1) - n7 >> 31;
            n7 = n7 - (1 << n4) & n6 | n7 & ~n6;
            byArray3[i] = (byte)(nArray[i] - n7 >> n4);
        }
        System.arraycopy(byArray2, n2, byArray3, n3, 64);
        if (n5 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray, n, 32, byArray3, 0, n3 + 64);
        }
        if (n5 == 4206593 || n5 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray, n, 32, byArray3, 0, n3 + 64);
        }
    }

    private static void hashFunction(byte[] byArray, int n, long[] lArray, byte[] byArray2, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray3 = new byte[n3 * n4 + 64];
        for (int i = 0; i < n4; ++i) {
            int n7 = n3 * i;
            for (int j = 0; j < n3; ++j) {
                long l = lArray[n7];
                long l2 = (long)(n6 / 2) - l >> 63;
                l = l - (long)n6 & l2 | l & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
                long l3 = l & (long)((1 << n5) - 1);
                l2 = (long)(1 << n5 - 1) - l3 >> 63;
                l3 = l3 - (long)(1 << n5) & l2 | l3 & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
                byArray3[n7++] = (byte)(l - l3 >> n5);
            }
        }
        System.arraycopy(byArray2, n2, byArray3, n3 * n4, 64);
        if (n6 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray, n, 32, byArray3, 0, n3 * n4 + 64);
        }
        if (n6 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray, n, 32, byArray3, 0, n3 * n4 + 64);
        }
    }

    private static int absolute(int n) {
        return (n >> 31 ^ n) - (n >> 31);
    }

    private static long absolute(long l) {
        return (l >> 63 ^ l) - (l >> 63);
    }

    private static boolean testRejection(int[] nArray, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            if (QTESLA.absolute(nArray[i]) <= n2 - n3) continue;
            return true;
        }
        return false;
    }

    private static boolean testRejection(long[] lArray, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            if (QTESLA.absolute(lArray[i]) <= (long)(n2 - n3)) continue;
            return true;
        }
        return false;
    }

    private static boolean testZ(int[] nArray, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= -(n2 - n3) && nArray[i] <= n2 - n3) continue;
            return true;
        }
        return false;
    }

    private static boolean testZ(long[] lArray, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            if (lArray[i] >= (long)(-(n2 - n3)) && lArray[i] <= (long)(n2 - n3)) continue;
            return true;
        }
        return false;
    }

    private static boolean testV(int[] nArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n; ++i) {
            int n5 = n3 / 2 - nArray[i] >> 31;
            int n6 = nArray[i] - n3 & n5 | nArray[i] & ~n5;
            int n7 = ~(QTESLA.absolute(n6) - (n3 / 2 - n4)) >>> 31;
            int n8 = n6;
            n6 = n6 + (1 << n2 - 1) - 1 >> n2;
            int n9 = ~(QTESLA.absolute(n6 = n8 - (n6 << n2)) - ((1 << n2 - 1) - n4)) >>> 31;
            if ((n7 | n9) != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean testV(long[] lArray, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n2; ++i) {
            long l = (long)(n4 / 2) - lArray[n + i] >> 63;
            long l2 = lArray[n + i] - (long)n4 & l | lArray[n + i] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            long l3 = (QTESLA.absolute(l2) - (long)(n4 / 2 - n5) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            long l4 = l2;
            l2 = (int)(l2 + (long)(1 << n3 - 1) - 1L >> n3);
            long l5 = (QTESLA.absolute(l2 = l4 - (l2 << n3)) - (long)((1 << n3 - 1) - n5) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            if ((l3 | l5) != 1L) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPolynomial(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = n2;
        int[] nArray2 = new int[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            nArray2[n4] = QTESLA.absolute(nArray[n4]);
        }
        for (n4 = 0; n4 < n3; ++n4) {
            for (int i = 0; i < n6 - 1; ++i) {
                int n7 = nArray2[i + 1] - nArray2[i] >> 31;
                int n8 = nArray2[i + 1] & n7 | nArray2[i] & ~n7;
                nArray2[i + 1] = nArray2[i] & n7 | nArray2[i + 1] & ~n7;
                nArray2[i] = n8;
            }
            n5 += nArray2[n6 - 1];
            --n6;
        }
        return n5 > n;
    }

    private static boolean checkPolynomial(long[] lArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = n3;
        short[] sArray = new short[n3];
        for (n5 = 0; n5 < n3; ++n5) {
            sArray[n5] = (short)QTESLA.absolute(lArray[n + n5]);
        }
        for (n5 = 0; n5 < n4; ++n5) {
            for (int i = 0; i < n7 - 1; ++i) {
                short s = (short)(sArray[i + 1] - sArray[i] >> 15);
                short s2 = (short)(sArray[i + 1] & s | sArray[i] & ~s);
                sArray[i + 1] = (short)(sArray[i] & s | sArray[i + 1] & ~s);
                sArray[i] = s2;
            }
            n6 += sArray[n7 - 1];
            --n7;
        }
        return n6 > n2;
    }

    private static int generateKeyPair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom, int n, int n2, int n3, long l, int n4, int n5, int n6, double d, int[] nArray, int n7, int n8) {
        int n9 = 0;
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[128];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        secureRandom.nextBytes(byArray3);
        if (n3 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray4, 0, 128, byArray3, 0, 32);
        }
        if (n3 == 4206593 || n3 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray4, 0, 128, byArray3, 0, 32);
        }
        do {
            if (n3 == 4205569) {
                Sample.polynomialGaussSamplerI(nArray3, 0, byArray4, 0, ++n9);
            }
            if (n3 == 4206593) {
                Sample.polynomialGaussSamplerIII(nArray3, 0, byArray4, 0, ++n9, n, d, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (n3 != 8404993) continue;
            Sample.polynomialGaussSamplerIII(nArray3, 0, byArray4, 0, ++n9, n, d, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(nArray3, n7, n, n2));
        do {
            if (n3 == 4205569) {
                Sample.polynomialGaussSamplerI(nArray2, 0, byArray4, 32, ++n9);
            }
            if (n3 == 4206593) {
                Sample.polynomialGaussSamplerIII(nArray2, 0, byArray4, 32, ++n9, n, d, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (n3 != 8404993) continue;
            Sample.polynomialGaussSamplerIII(nArray2, 0, byArray4, 32, ++n9, n, d, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(nArray2, n8, n, n2));
        Polynomial.polynomialUniform(nArray4, byArray4, 64, n, n3, l, n4, n5, n6);
        Polynomial.polynomialMultiplication(nArray5, nArray4, nArray2, n, n3, l, nArray);
        Polynomial.polynomialAdditionCorrection(nArray5, nArray5, nArray3, n, n3);
        if (n3 == 4205569) {
            Pack.encodePrivateKeyI(byArray2, nArray2, nArray3, byArray4, 64);
            Pack.encodePublicKey(byArray, nArray5, byArray4, 64, 512, 23);
        }
        if (n3 == 4206593) {
            Pack.encodePrivateKeyIIISize(byArray2, nArray2, nArray3, byArray4, 64);
            Pack.encodePublicKey(byArray, nArray5, byArray4, 64, 1024, 23);
        }
        if (n3 == 8404993) {
            Pack.encodePrivateKeyIIISpeed(byArray2, nArray2, nArray3, byArray4, 64);
            Pack.encodePublicKeyIIISpeed(byArray, nArray5, byArray4, 64);
        }
        return 0;
    }

    public static int generateKeyPairI(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 512, 30, 4205569, 3098553343L, 23, 19, 113307, 27.0, PolynomialHeuristic.ZETA_I, 1586, 1586);
    }

    public static int generateKeyPairIIISize(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 1024, 48, 4206593, 4148178943L, 23, 38, 1217638, 9.0, PolynomialHeuristic.ZETA_III_SIZE, 910, 910);
    }

    public static int generateKeyPairIIISpeed(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 1024, 48, 8404993, 4034936831L, 24, 38, 237839, 12.0, PolynomialHeuristic.ZETA_III_SPEED, 1147, 1233);
    }

    private static int generateKeyPair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom, int n, int n2, int n3, int n4, long l, int n5, int n6, int n7, double d, long[] lArray, int n8, int n9) {
        int n10;
        int n11 = 0;
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32 * (n2 + 3)];
        long[] lArray2 = new long[n];
        long[] lArray3 = new long[n];
        long[] lArray4 = new long[n * n2];
        long[] lArray5 = new long[n * n2];
        long[] lArray6 = new long[n * n2];
        secureRandom.nextBytes(byArray3);
        if (n4 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray4, 0, 32 * (n2 + 3), byArray3, 0, 32);
        }
        if (n4 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray4, 0, 32 * (n2 + 3), byArray3, 0, 32);
        }
        for (n10 = 0; n10 < n2; ++n10) {
            do {
                if (n4 == 485978113) {
                    Sample.polynomialGaussSamplerIP(lArray4, n * n10, byArray4, 32 * n10, ++n11);
                }
                if (n4 != 1129725953) continue;
                Sample.polynomialGaussSamplerIIIP(lArray4, n * n10, byArray4, 32 * n10, ++n11);
            } while (QTESLA.checkPolynomial(lArray4, n * n10, n8, n, n3));
        }
        do {
            if (n4 == 485978113) {
                Sample.polynomialGaussSamplerIP(lArray2, 0, byArray4, 32 * n2, ++n11);
            }
            if (n4 != 1129725953) continue;
            Sample.polynomialGaussSamplerIIIP(lArray2, 0, byArray4, 32 * n2, ++n11);
        } while (QTESLA.checkPolynomial(lArray2, 0, n9, n, n3));
        Polynomial.polynomialUniform(lArray5, byArray4, 32 * (n2 + 1), n, n2, n4, l, n5, n6, n7);
        Polynomial.polynomialNumberTheoreticTransform(lArray3, lArray2, n);
        for (n10 = 0; n10 < n2; ++n10) {
            Polynomial.polynomialMultiplication(lArray6, n * n10, lArray5, n * n10, lArray3, 0, n, n4, l);
            Polynomial.polynomialAddition(lArray6, n * n10, lArray6, n * n10, lArray4, n * n10, n);
            for (int i = 0; i < n; ++i) {
                long l2 = (long)n4 - lArray6[n * n10 + i] >> 63;
                int n12 = n * n10 + i;
                lArray6[n12] = lArray6[n12] - ((long)n4 & l2);
            }
        }
        Pack.packPrivateKey(byArray2, lArray2, lArray4, byArray4, 32 * (n2 + 1), n, n2);
        if (n4 == 485978113) {
            Pack.encodePublicKeyIP(byArray, lArray6, byArray4, 32 * (n2 + 1));
        }
        if (n4 == 1129725953) {
            Pack.encodePublicKeyIIIP(byArray, lArray6, byArray4, 32 * (n2 + 1));
        }
        return 0;
    }

    public static int generateKeyPairIP(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 1024, 4, 25, 485978113, 3421990911L, 29, 108, 472064468, 10.0, PolynomialProvablySecure.ZETA_I_P, 554, 554);
    }

    public static int generateKeyPairIIIP(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 2048, 5, 40, 1129725953, 861290495L, 31, 180, 851423148, 10.0, PolynomialProvablySecure.ZETA_III_P, 901, 901);
    }

    private static int signing(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, SecureRandom secureRandom, int n3, int n4, int n5, long l, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int[] nArray) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[128];
        byte[] byArray7 = new byte[64];
        byte[] byArray8 = new byte[32];
        int[] nArray2 = new int[n4];
        short[] sArray = new short[n4];
        short[] sArray2 = new short[n3];
        short[] sArray3 = new short[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        int n16 = 0;
        if (n5 == 4205569) {
            Pack.decodePrivateKeyI(byArray7, sArray2, sArray3, byArray3);
        }
        if (n5 == 4206593) {
            Pack.decodePrivateKeyIIISize(byArray7, sArray2, sArray3, byArray3);
        }
        if (n5 == 8404993) {
            Pack.decodePrivateKeyIIISpeed(byArray7, sArray2, sArray3, byArray3);
        }
        secureRandom.nextBytes(byArray8);
        System.arraycopy(byArray8, 0, byArray6, 32, 32);
        System.arraycopy(byArray7, 32, byArray6, 0, 32);
        if (n5 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray6, 64, 64, byArray2, 0, n2);
            HashUtils.secureHashAlgorithmKECCAK128(byArray5, 0, 32, byArray6, 0, 128);
        }
        if (n5 == 4206593 || n5 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray6, 64, 64, byArray2, 0, n2);
            HashUtils.secureHashAlgorithmKECCAK256(byArray5, 0, 32, byArray6, 0, 128);
        }
        Polynomial.polynomialUniform(nArray3, byArray7, 0, n3, n5, l, n6, n12, n13);
        while (true) {
            Sample.sampleY(nArray5, byArray5, 0, ++n16, n3, n5, n7, n8);
            Polynomial.polynomialMultiplication(nArray4, nArray3, nArray5, n3, n5, l, nArray);
            QTESLA.hashFunction(byArray4, 0, nArray4, byArray6, 64, n3, n9, n5);
            Sample.encodeC(nArray2, sArray, byArray4, 0, n3, n4);
            Polynomial.sparsePolynomialMultiplication16(nArray7, sArray2, nArray2, sArray, n3, n4);
            Polynomial.polynomialAddition(nArray6, nArray5, nArray7, n3);
            if (QTESLA.testRejection(nArray6, n3, n7, n10)) continue;
            Polynomial.sparsePolynomialMultiplication16(nArray8, sArray3, nArray2, sArray, n3, n4);
            Polynomial.polynomialSubtractionCorrection(nArray4, nArray4, nArray8, n3, n5);
            if (!QTESLA.testV(nArray4, n3, n9, n5, n11)) break;
        }
        if (n5 == 4205569) {
            Pack.encodeSignature(byArray, 0, byArray4, 0, nArray6, n3, n9);
        }
        if (n5 == 4206593) {
            Pack.encodeSignature(byArray, 0, byArray4, 0, nArray6, n3, n9);
        }
        if (n5 == 8404993) {
            Pack.encodeSignatureIIISpeed(byArray, 0, byArray4, 0, nArray6);
        }
        return 0;
    }

    static int signingI(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n, n2, byArray3, secureRandom, 512, 30, 4205569, 3098553343L, 23, 1048575, 20, 21, 1586, 1586, 19, 113307, 1021, 32, PolynomialHeuristic.ZETA_I);
    }

    static int signingIIISize(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n, n2, byArray3, secureRandom, 1024, 48, 4206593, 4148178943L, 23, 1048575, 20, 21, 910, 910, 38, 1217638, 1021, 32, PolynomialHeuristic.ZETA_III_SIZE);
    }

    static int signingIIISpeed(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n, n2, byArray3, secureRandom, 1024, 48, 8404993, 4034936831L, 24, 0x1FFFFF, 21, 22, 1233, 1147, 38, 237839, 511, 32, PolynomialHeuristic.ZETA_III_SPEED);
    }

    private static int signing(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, SecureRandom secureRandom, int n3, int n4, int n5, int n6, long l, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[128];
        byte[] byArray7 = new byte[32];
        int[] nArray = new int[n5];
        short[] sArray = new short[n5];
        long[] lArray = new long[n3 * n4];
        long[] lArray2 = new long[n3 * n4];
        long[] lArray3 = new long[n3];
        long[] lArray4 = new long[n3];
        long[] lArray5 = new long[n3];
        long[] lArray6 = new long[n3];
        long[] lArray7 = new long[n3 * n4];
        boolean bl = false;
        int n18 = 0;
        secureRandom.nextBytes(byArray7);
        System.arraycopy(byArray7, 0, byArray6, 32, 32);
        System.arraycopy(byArray3, n15 - 32, byArray6, 0, 32);
        if (n6 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray6, 64, 64, byArray2, 0, n2);
            HashUtils.secureHashAlgorithmKECCAK128(byArray5, 0, 32, byArray6, 0, 128);
        }
        if (n6 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray6, 64, 64, byArray2, 0, n2);
            HashUtils.secureHashAlgorithmKECCAK256(byArray5, 0, 32, byArray6, 0, 128);
        }
        Polynomial.polynomialUniform(lArray, byArray3, n15 - 64, n3, n4, n6, l, n7, n13, n14);
        while (true) {
            int n19;
            Sample.sampleY(lArray3, byArray5, 0, ++n18, n3, n6, n8, n9);
            Polynomial.polynomialNumberTheoreticTransform(lArray4, lArray3, n3);
            for (n19 = 0; n19 < n4; ++n19) {
                Polynomial.polynomialMultiplication(lArray2, n3 * n19, lArray, n3 * n19, lArray4, 0, n3, n6, l);
            }
            QTESLA.hashFunction(byArray4, 0, lArray2, byArray6, 64, n3, n4, n10, n6);
            Sample.encodeC(nArray, sArray, byArray4, 0, n3, n5);
            Polynomial.sparsePolynomialMultiplication8(lArray6, 0, byArray3, 0, nArray, sArray, n3, n5);
            Polynomial.polynomialAddition(lArray5, 0, lArray3, 0, lArray6, 0, n3);
            if (QTESLA.testRejection(lArray5, n3, n8, n11)) continue;
            for (n19 = 0; n19 < n4; ++n19) {
                Polynomial.sparsePolynomialMultiplication8(lArray7, n3 * n19, byArray3, n3 * (n19 + 1), nArray, sArray, n3, n5);
                Polynomial.polynomialSubtraction(lArray2, n3 * n19, lArray2, n3 * n19, lArray7, n3 * n19, n3, n6, n16, n17);
                bl = QTESLA.testV(lArray2, n3 * n19, n3, n10, n6, n12);
                if (bl) break;
            }
            if (!bl) break;
        }
        if (n6 == 485978113) {
            Pack.encodeSignatureIP(byArray, 0, byArray4, 0, lArray5);
        }
        if (n6 == 1129725953) {
            Pack.encodeSignatureIIIP(byArray, 0, byArray4, 0, lArray5);
        }
        return 0;
    }

    public static int signingIP(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n, n2, byArray3, secureRandom, 1024, 4, 25, 485978113, 3421990911L, 29, 0x1FFFFF, 21, 22, 554, 554, 108, 472064468, 5184, 1, 29);
    }

    public static int signingIIIP(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n, n2, byArray3, secureRandom, 2048, 5, 40, 1129725953, 861290495L, 31, 0x7FFFFF, 23, 24, 901, 901, 180, 851423148, 12352, 15, 34);
    }

    private static int verifying(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3, int n4, int n5, long l, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int[] nArray) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[64];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n4];
        short[] sArray = new short[n4];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        if (n2 < n11) {
            return -1;
        }
        if (n5 == 4205569 || n5 == 4206593) {
            Pack.decodeSignature(byArray4, nArray5, byArray2, n, n3, n8);
        }
        if (n5 == 8404993) {
            Pack.decodeSignatureIIISpeed(byArray4, nArray5, byArray2, n);
        }
        if (QTESLA.testZ(nArray5, n3, n7, n9)) {
            return -2;
        }
        if (n5 == 4205569 || n5 == 4206593) {
            Pack.decodePublicKey(nArray2, byArray6, 0, byArray3, n3, n6);
        }
        if (n5 == 8404993) {
            Pack.decodePublicKeyIIISpeed(nArray2, byArray6, 0, byArray3);
        }
        Polynomial.polynomialUniform(nArray7, byArray6, 0, n3, n5, l, n6, n12, n13);
        Sample.encodeC(nArray3, sArray, byArray4, 0, n3, n4);
        Polynomial.sparsePolynomialMultiplication32(nArray6, nArray2, nArray3, sArray, n3, n4);
        Polynomial.polynomialMultiplication(nArray4, nArray7, nArray5, n3, n5, l, nArray);
        Polynomial.polynomialSubtractionMontgomery(nArray4, nArray4, nArray6, n3, n5, l, n10);
        if (n5 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        if (n5 == 4206593 || n5 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        QTESLA.hashFunction(byArray5, 0, nArray4, byArray7, 0, n3, n8, n5);
        if (!CommonFunction.memoryEqual(byArray4, 0, byArray5, 0, 32)) {
            return -3;
        }
        return 0;
    }

    static int verifyingI(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n, n2, byArray3, 512, 30, 4205569, 3098553343L, 23, 1048575, 21, 1586, 1081347, 1376, 19, 113307, 1021, 32, PolynomialHeuristic.ZETA_I);
    }

    static int verifyingIIISize(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n, n2, byArray3, 1024, 48, 4206593, 4148178943L, 23, 1048575, 21, 910, 35843, 2720, 38, 1217638, 1021, 32, PolynomialHeuristic.ZETA_III_SIZE);
    }

    static int verifyingIIISpeed(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n, n2, byArray3, 1024, 48, 8404993, 4034936831L, 24, 0x1FFFFF, 22, 1233, 15873, 2848, 38, 237839, 511, 32, PolynomialHeuristic.ZETA_III_SPEED);
    }

    private static int verifying(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3, int n4, int n5, int n6, long l, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, long[] lArray) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[64];
        int[] nArray = new int[n3 * n4];
        int[] nArray2 = new int[n5];
        short[] sArray = new short[n5];
        long[] lArray2 = new long[n3 * n4];
        long[] lArray3 = new long[n3];
        long[] lArray4 = new long[n3];
        long[] lArray5 = new long[n3 * n4];
        long[] lArray6 = new long[n3 * n4];
        if (n2 < n11) {
            return -1;
        }
        if (n6 == 485978113) {
            Pack.decodeSignatureIP(byArray4, lArray3, byArray2, n);
        }
        if (n6 == 1129725953) {
            Pack.decodeSignatureIIIP(byArray4, lArray3, byArray2, n);
        }
        if (QTESLA.testZ(lArray3, n3, n8, n10)) {
            return -2;
        }
        if (n6 == 485978113) {
            Pack.decodePublicKeyIP(nArray, byArray6, 0, byArray3);
        }
        if (n6 == 1129725953) {
            Pack.decodePublicKeyIIIP(nArray, byArray6, 0, byArray3);
        }
        Polynomial.polynomialUniform(lArray6, byArray6, 0, n3, n4, n6, l, n7, n12, n13);
        Sample.encodeC(nArray2, sArray, byArray4, 0, n3, n5);
        Polynomial.polynomialNumberTheoreticTransform(lArray4, lArray3, n3);
        for (int i = 0; i < n4; ++i) {
            Polynomial.polynomialMultiplication(lArray2, n3 * i, lArray6, n3 * i, lArray4, 0, n3, n6, l);
            Polynomial.sparsePolynomialMultiplication32(lArray5, n3 * i, nArray, n3 * i, nArray2, sArray, n3, n5, n6, n14, n15);
            Polynomial.polynomialSubtraction(lArray2, n3 * i, lArray2, n3 * i, lArray5, n3 * i, n3, n6, n14, n15);
        }
        if (n6 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        if (n6 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        QTESLA.hashFunction(byArray5, 0, lArray2, byArray7, 0, n3, n4, n9, n6);
        if (!CommonFunction.memoryEqual(byArray4, 0, byArray5, 0, 32)) {
            return -3;
        }
        return 0;
    }

    static int verifyingPI(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n, n2, byArray3, 1024, 4, 25, 485978113, 3421990911L, 29, 0x1FFFFF, 22, 554, 2848, 108, 472064468, 1, 29, PolynomialProvablySecure.ZETA_I_P);
    }

    static int verifyingPIII(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n, n2, byArray3, 2048, 5, 40, 1129725953, 861290495L, 31, 0x7FFFFF, 24, 901, 6176, 180, 851423148, 15, 34, PolynomialProvablySecure.ZETA_III_P);
    }
}

