/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlockReader;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;

public abstract class AbstractBitcoinRecordReader<K, V>
implements RecordReader<K, V> {
    public static final String CONF_BUFFERSIZE = "io.file.buffer.size";
    public static final String CONF_MAXBLOCKSIZE = "hadoopcryptoledger.bitcoinblockinputformat.maxblocksize";
    public static final String CONF_FILTERMAGIC = "hadoopcryptoledger.bitcoinblockinputformat.filter.magic";
    public static final String CONF_USEDIRECTBUFFER = "hadoopcryptoledeger.bitcoinblockinputformat.usedirectbuffer";
    public static final String CONF_READAUXPOW = "hadoopcryptoledger.bitcoinblockinputformat.readauxpow";
    public static final int DEFAULT_BUFFERSIZE = 65536;
    public static final int DEFAULT_MAXSIZE_BITCOINBLOCK = 0x800000;
    public static final String DEFAULT_MAGIC = "F9BEB4D9";
    public static final boolean DEFAULT_USEDIRECTBUFFER = false;
    public static final boolean DEFAULT_READAUXPOW = false;
    private static final Log LOG = LogFactory.getLog((String)AbstractBitcoinRecordReader.class.getName());
    private int bufferSize = 0;
    private int maxSizeBitcoinBlock = 0;
    private boolean useDirectBuffer = false;
    private boolean readAuxPOW = false;
    private String specificMagic = "";
    private String[] specificMagicStringArray;
    private byte[][] specificMagicByteArray;
    private CompressionCodec codec;
    private Decompressor decompressor;
    private Reporter reporter;
    private Configuration conf;
    private long start;
    private long end;
    private final Seekable filePosition;
    private FSDataInputStream fileIn;
    private BitcoinBlockReader bbr;

    public AbstractBitcoinRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException, HadoopCryptoLedgerConfigurationException, BitcoinBlockReadException {
        LOG.debug((Object)"Reading configuration");
        this.reporter = reporter;
        this.conf = job;
        this.maxSizeBitcoinBlock = this.conf.getInt(CONF_MAXBLOCKSIZE, 0x800000);
        this.bufferSize = this.conf.getInt(CONF_BUFFERSIZE, 65536);
        this.specificMagic = this.conf.get(CONF_FILTERMAGIC);
        if (this.specificMagic == null || this.specificMagic.length() == 0) {
            this.specificMagic = DEFAULT_MAGIC;
        }
        if (this.specificMagic != null && this.specificMagic.length() > 0) {
            this.specificMagicStringArray = this.specificMagic.split(",");
            this.specificMagicByteArray = new byte[this.specificMagicStringArray.length][4];
            for (int i = 0; i < this.specificMagicStringArray.length; ++i) {
                byte[] currentMagicNo = BitcoinUtil.convertHexStringToByteArray(this.specificMagicStringArray[i]);
                if (currentMagicNo.length != 4) {
                    throw new HadoopCryptoLedgerConfigurationException("Error: Configuration. Magic number has not a length of 4 bytes. Index: " + i);
                }
                this.specificMagicByteArray[i] = currentMagicNo;
            }
        }
        this.useDirectBuffer = this.conf.getBoolean(CONF_USEDIRECTBUFFER, false);
        this.readAuxPOW = this.conf.getBoolean(CONF_READAUXPOW, false);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        this.codec = new CompressionCodecFactory((Configuration)job).getCodec(file);
        FileSystem fs = file.getFileSystem((Configuration)job);
        this.fileIn = fs.open(file);
        if (this.isCompressedInput()) {
            LOG.debug((Object)"Decompressing file");
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)this.codec);
            if (this.codec instanceof SplittableCompressionCodec) {
                LOG.debug((Object)"SplittableCompressionCodec");
                SplitCompressionInputStream cIn = ((SplittableCompressionCodec)this.codec).createInputStream((InputStream)this.fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.CONTINUOUS);
                this.bbr = new BitcoinBlockReader((InputStream)cIn, this.maxSizeBitcoinBlock, this.bufferSize, this.specificMagicByteArray, this.useDirectBuffer, this.readAuxPOW);
                this.start = cIn.getAdjustedStart();
                this.end = cIn.getAdjustedEnd();
                this.filePosition = cIn;
            } else {
                LOG.debug((Object)"Not-splitable compression codec");
                this.bbr = new BitcoinBlockReader((InputStream)this.codec.createInputStream((InputStream)this.fileIn, this.decompressor), this.maxSizeBitcoinBlock, this.bufferSize, this.specificMagicByteArray, this.useDirectBuffer, this.readAuxPOW);
                this.filePosition = this.fileIn;
            }
        } else {
            LOG.debug((Object)"Processing file without compression");
            this.fileIn.seek(this.start);
            this.bbr = new BitcoinBlockReader((InputStream)this.fileIn, this.maxSizeBitcoinBlock, this.bufferSize, this.specificMagicByteArray, this.useDirectBuffer, this.readAuxPOW);
            this.filePosition = this.fileIn;
        }
        LOG.debug((Object)"Seeking to block start");
        this.reporter.setStatus("Seeking Block start");
        this.bbr.seekBlockStart();
        this.reporter.setStatus("Ready to read");
    }

    public long getFilePosition() throws IOException {
        return this.filePosition.getPos();
    }

    public long getEnd() {
        return this.end;
    }

    public BitcoinBlockReader getBbr() {
        return this.bbr;
    }

    public synchronized float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    private boolean isCompressedInput() {
        return this.codec != null;
    }

    public synchronized long getPos() throws IOException {
        return this.filePosition.getPos();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.bbr != null) {
                this.bbr.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }
}

