/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapred.AbstractBitcoinFileInputFormat;
import org.zuinnote.hadoop.bitcoin.format.mapred.BitcoinBlockRecordReader;

public class BitcoinBlockFileInputFormat
extends AbstractBitcoinFileInputFormat<BytesWritable, BitcoinBlock> {
    private static final Log LOGFI = LogFactory.getLog((String)BitcoinBlockFileInputFormat.class.getName());

    @Override
    public RecordReader<BytesWritable, BitcoinBlock> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            return new BitcoinBlockRecordReader((FileSplit)split, job, reporter);
        }
        catch (BitcoinBlockReadException | HadoopCryptoLedgerConfigurationException e) {
            LOGFI.error((Object)e);
            return null;
        }
    }
}

