/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapred.AbstractBitcoinRecordReader;

public class BitcoinBlockRecordReader
extends AbstractBitcoinRecordReader<BytesWritable, BitcoinBlock> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockRecordReader.class.getName());

    public BitcoinBlockRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException, HadoopCryptoLedgerConfigurationException, BitcoinBlockReadException {
        super(split, job, reporter);
    }

    public BytesWritable createKey() {
        return new BytesWritable();
    }

    public BitcoinBlock createValue() {
        return new BitcoinBlock();
    }

    public boolean next(BytesWritable key, BitcoinBlock value) throws IOException {
        if (this.getFilePosition() <= this.getEnd()) {
            BitcoinBlock dataBlock = null;
            try {
                dataBlock = this.getBbr().readBlock();
            }
            catch (BitcoinBlockReadException e) {
                LOG.error((Object)e);
            }
            if (dataBlock == null) {
                return false;
            }
            byte[] hashMerkleRoot = dataBlock.getHashMerkleRoot();
            byte[] hashPrevBlock = dataBlock.getHashPrevBlock();
            byte[] newKey = new byte[hashMerkleRoot.length + hashPrevBlock.length];
            for (int i = 0; i < hashMerkleRoot.length; ++i) {
                newKey[i] = hashMerkleRoot[i];
            }
            for (int j = 0; j < hashPrevBlock.length; ++j) {
                newKey[j + hashMerkleRoot.length] = hashPrevBlock[j];
            }
            key.set(newKey, 0, newKey.length);
            value.set(dataBlock);
            return true;
        }
        return false;
    }
}

