/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlockReader;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;

public abstract class AbstractBitcoinRecordReader<K, V>
extends RecordReader<K, V> {
    public static final String CONF_BUFFERSIZE = "io.file.buffer.size";
    public static final String CONF_MAXBLOCKSIZE = "hadoopcryptoledger.bitcoinblockinputformat.maxblocksize";
    public static final String CONF_FILTERMAGIC = "hadoopcryptoledger.bitcoinblockinputformat.filter.magic";
    public static final String CONF_USEDIRECTBUFFER = "hadoopcryptoledeger.bitcoinblockinputformat.usedirectbuffer";
    public static final String CONF_READAUXPOW = "hadoopcryptoledger.bitcoinblockinputformat.readauxpow";
    public static final int DEFAULT_BUFFERSIZE = 65536;
    public static final int DEFAULT_MAXSIZE_BITCOINBLOCK = 0x800000;
    public static final String DEFAULT_MAGIC = "F9BEB4D9";
    public static final boolean DEFAULT_USEDIRECTBUFFER = false;
    public static final boolean DEFAULT_READAUXPOW = false;
    private static final Log LOG = LogFactory.getLog((String)AbstractBitcoinRecordReader.class.getName());
    private int bufferSize = 0;
    private int maxSizeBitcoinBlock = 0;
    private boolean useDirectBuffer = false;
    private boolean readAuxPOW = false;
    private String specificMagic = "";
    private String[] specificMagicStringArray;
    private byte[][] specificMagicByteArray;
    private CompressionCodec codec;
    private Decompressor decompressor;
    private long start;
    private long end;
    private Seekable filePosition;
    private BitcoinBlockReader bbr;

    public AbstractBitcoinRecordReader(Configuration conf) throws HadoopCryptoLedgerConfigurationException {
        this.maxSizeBitcoinBlock = conf.getInt(CONF_MAXBLOCKSIZE, 0x800000);
        this.bufferSize = conf.getInt(CONF_BUFFERSIZE, 65536);
        this.specificMagic = conf.get(CONF_FILTERMAGIC);
        if (this.specificMagic == null || this.specificMagic.length() == 0) {
            this.specificMagic = DEFAULT_MAGIC;
        }
        if (this.specificMagic != null && this.specificMagic.length() > 0) {
            this.specificMagicStringArray = this.specificMagic.split(",");
            this.specificMagicByteArray = new byte[this.specificMagicStringArray.length][4];
            for (int i = 0; i < this.specificMagicStringArray.length; ++i) {
                byte[] currentMagicNo = BitcoinUtil.convertHexStringToByteArray(this.specificMagicStringArray[i]);
                if (currentMagicNo.length != 4) {
                    throw new HadoopCryptoLedgerConfigurationException("Error: Configuration. Magic number has not a length of 4 bytes. Index: " + i);
                }
                this.specificMagicByteArray[i] = currentMagicNo;
            }
        }
        this.useDirectBuffer = conf.getBoolean(CONF_USEDIRECTBUFFER, false);
        this.readAuxPOW = conf.getBoolean(CONF_READAUXPOW, false);
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fSplit = (FileSplit)split;
        this.start = fSplit.getStart();
        this.end = this.start + fSplit.getLength();
        Path file = fSplit.getPath();
        this.codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        FSDataInputStream fileIn = fs.open(file);
        if (this.isCompressedInput()) {
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)this.codec);
            if (this.codec instanceof SplittableCompressionCodec) {
                SplitCompressionInputStream cIn = ((SplittableCompressionCodec)this.codec).createInputStream((InputStream)fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.CONTINUOUS);
                this.bbr = new BitcoinBlockReader((InputStream)cIn, this.maxSizeBitcoinBlock, this.bufferSize, this.specificMagicByteArray, this.useDirectBuffer, this.readAuxPOW);
                this.start = cIn.getAdjustedStart();
                this.end = cIn.getAdjustedEnd();
                this.filePosition = cIn;
            } else {
                this.bbr = new BitcoinBlockReader((InputStream)this.codec.createInputStream((InputStream)fileIn, this.decompressor), this.maxSizeBitcoinBlock, this.bufferSize, this.specificMagicByteArray, this.useDirectBuffer, this.readAuxPOW);
                this.filePosition = fileIn;
            }
        } else {
            fileIn.seek(this.start);
            this.bbr = new BitcoinBlockReader((InputStream)fileIn, this.maxSizeBitcoinBlock, this.bufferSize, this.specificMagicByteArray, this.useDirectBuffer, this.readAuxPOW);
            this.filePosition = fileIn;
        }
        try {
            this.bbr.seekBlockStart();
        }
        catch (BitcoinBlockReadException bbre) {
            LOG.error((Object)"Error reading Bitcoin blockchhain data");
            LOG.error((Object)bbre);
        }
    }

    public BitcoinBlockReader getBbr() {
        return this.bbr;
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    public long getEnd() {
        return this.end;
    }

    public long getFilePosition() throws IOException {
        return this.filePosition.getPos();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.bbr != null) {
                this.bbr.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }

    private boolean isCompressedInput() {
        return this.codec != null;
    }
}

