/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.common;

import java.io.Serializable;
import java.math.BigInteger;
import org.zuinnote.hadoop.ethereum.format.common.EthereumUtil;

public class EthereumBlockHeader
implements Serializable {
    private static final long serialVersionUID = 2446091414374317679L;
    private byte[] parentHash;
    private byte[] uncleHash;
    private byte[] coinBase;
    private byte[] stateRoot;
    private byte[] txTrieRoot;
    private byte[] receiptTrieRoot;
    private byte[] logsBloom;
    private byte[] difficulty;
    private long timestamp;
    private BigInteger number;
    private byte[] numberRaw;
    private BigInteger gasLimit;
    private byte[] gasLimitRaw;
    private BigInteger gasUsed;
    private byte[] gasUsedRaw;
    private byte[] mixHash;
    private byte[] extraData;
    private byte[] nonce;

    public byte[] getParentHash() {
        return this.parentHash;
    }

    public void setParentHash(byte[] parentHash) {
        this.parentHash = parentHash;
    }

    public byte[] getUncleHash() {
        return this.uncleHash;
    }

    public void setUncleHash(byte[] uncleHash) {
        this.uncleHash = uncleHash;
    }

    public byte[] getCoinBase() {
        return this.coinBase;
    }

    public void setCoinBase(byte[] coinBase) {
        this.coinBase = coinBase;
    }

    public byte[] getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(byte[] stateRoot) {
        this.stateRoot = stateRoot;
    }

    public byte[] getTxTrieRoot() {
        return this.txTrieRoot;
    }

    public void setTxTrieRoot(byte[] txTrieRoot) {
        this.txTrieRoot = txTrieRoot;
    }

    public byte[] getReceiptTrieRoot() {
        return this.receiptTrieRoot;
    }

    public void setReceiptTrieRoot(byte[] receiptTrieRoot) {
        this.receiptTrieRoot = receiptTrieRoot;
    }

    public byte[] getLogsBloom() {
        return this.logsBloom;
    }

    public void setLogsBloom(byte[] logsBloom) {
        this.logsBloom = logsBloom;
    }

    public byte[] getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(byte[] difficulty) {
        this.difficulty = difficulty;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public BigInteger getNumber() {
        if (this.number == null) {
            this.number = EthereumUtil.convertVarNumberToBigInteger(this.numberRaw);
        }
        return this.number;
    }

    public void setNumber(BigInteger number) {
        this.number = number;
    }

    public BigInteger getGasLimit() {
        if (this.gasLimit == null) {
            this.gasLimit = EthereumUtil.convertVarNumberToBigInteger(this.gasLimitRaw);
        }
        return this.gasLimit;
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
    }

    public BigInteger getGasUsed() {
        if (this.gasUsed == null) {
            this.gasUsed = EthereumUtil.convertVarNumberToBigInteger(this.gasUsedRaw);
        }
        return this.gasUsed;
    }

    public void setGasUsed(BigInteger gasUsed) {
        this.gasUsed = gasUsed;
    }

    public byte[] getMixHash() {
        return this.mixHash;
    }

    public void setMixHash(byte[] mixHash) {
        this.mixHash = mixHash;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public void setExtraData(byte[] extraData) {
        this.extraData = extraData;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public void set(EthereumBlockHeader newEthereumBlockHeader) {
        this.parentHash = newEthereumBlockHeader.getParentHash();
        this.uncleHash = newEthereumBlockHeader.getUncleHash();
        this.coinBase = newEthereumBlockHeader.getCoinBase();
        this.stateRoot = newEthereumBlockHeader.getStateRoot();
        this.txTrieRoot = newEthereumBlockHeader.getTxTrieRoot();
        this.receiptTrieRoot = newEthereumBlockHeader.getReceiptTrieRoot();
        this.logsBloom = newEthereumBlockHeader.getLogsBloom();
        this.difficulty = newEthereumBlockHeader.getDifficulty();
        this.timestamp = newEthereumBlockHeader.getTimestamp();
        this.number = newEthereumBlockHeader.getNumber();
        this.numberRaw = newEthereumBlockHeader.getNumberRaw();
        this.gasLimit = newEthereumBlockHeader.getGasLimit();
        this.gasLimitRaw = newEthereumBlockHeader.getGasLimitRaw();
        this.gasUsed = newEthereumBlockHeader.getGasUsed();
        this.gasUsedRaw = newEthereumBlockHeader.getGasUsedRaw();
        this.mixHash = newEthereumBlockHeader.getMixHash();
        this.extraData = newEthereumBlockHeader.getExtraData();
        this.nonce = newEthereumBlockHeader.getNonce();
    }

    public byte[] getNumberRaw() {
        return this.numberRaw;
    }

    public void setNumberRaw(byte[] numberRaw) {
        this.numberRaw = numberRaw;
    }

    public byte[] getGasLimitRaw() {
        return this.gasLimitRaw;
    }

    public void setGasLimitRaw(byte[] gasLimitRaw) {
        this.gasLimitRaw = gasLimitRaw;
    }

    public byte[] getGasUsedRaw() {
        return this.gasUsedRaw;
    }

    public void setGasUsedRaw(byte[] gasUsedRaw) {
        this.gasUsedRaw = gasUsedRaw;
    }
}

