/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuinnote.hadoop.ethereum.format.common.EthereumBlock;
import org.zuinnote.hadoop.ethereum.format.common.EthereumBlockHeader;
import org.zuinnote.hadoop.ethereum.format.common.EthereumTransaction;
import org.zuinnote.hadoop.ethereum.format.common.EthereumUtil;
import org.zuinnote.hadoop.ethereum.format.common.rlp.RLPElement;
import org.zuinnote.hadoop.ethereum.format.common.rlp.RLPList;
import org.zuinnote.hadoop.ethereum.format.common.rlp.RLPObject;
import org.zuinnote.hadoop.ethereum.format.exception.EthereumBlockReadException;

public class EthereumBlockReader
implements Serializable {
    private static final Log LOG = LogFactory.getLog((String)EthereumBlockReader.class.getName());
    private InputStream in;
    private int bufferSize;
    private int maxSizeEthereumBlock;
    private boolean useDirectBuffer;
    private ByteBuffer preAllocatedDirectByteBuffer;

    private EthereumBlockReader() {
    }

    public EthereumBlockReader(InputStream in, int maxSizeEthereumBlock, int bufferSize, boolean useDirectBuffer) {
        this.bufferSize = bufferSize;
        this.maxSizeEthereumBlock = maxSizeEthereumBlock;
        this.useDirectBuffer = useDirectBuffer;
        this.in = this.bufferSize <= 0 ? in : new BufferedInputStream(in, this.bufferSize);
        if (this.useDirectBuffer) {
            this.preAllocatedDirectByteBuffer = ByteBuffer.allocateDirect(this.maxSizeEthereumBlock);
        }
    }

    public EthereumBlock readBlock() throws IOException, EthereumBlockReadException {
        ByteBuffer rawBlock = this.readRawBlock();
        if (rawBlock == null) {
            return null;
        }
        RLPObject blockObject = EthereumUtil.rlpDecodeNextItem(rawBlock);
        if (blockObject == null || !(blockObject instanceof RLPList)) {
            throw new EthereumBlockReadException("Invalid Ethereum Block: Not encoded RLPList");
        }
        RLPList block = (RLPList)blockObject;
        RLPList rlpHeader = (RLPList)block.getRlpList().get(0);
        RLPList rlpTransactions = (RLPList)block.getRlpList().get(1);
        RLPList rlpUncles = (RLPList)block.getRlpList().get(2);
        EthereumBlockHeader ethereumBlockHeader = this.parseRLPBlockHeader(rlpHeader);
        List<EthereumTransaction> ethereumTransactions = this.parseRLPTransactions(rlpTransactions);
        List<EthereumBlockHeader> uncleHeaders = this.parseRLPUncleHeaders(rlpUncles);
        return new EthereumBlock(ethereumBlockHeader, ethereumTransactions, uncleHeaders);
    }

    private EthereumBlockHeader parseRLPBlockHeader(RLPList rlpHeader) {
        EthereumBlockHeader result = new EthereumBlockHeader();
        result.setParentHash(((RLPElement)rlpHeader.getRlpList().get(0)).getRawData());
        result.setUncleHash(((RLPElement)rlpHeader.getRlpList().get(1)).getRawData());
        result.setCoinBase(((RLPElement)rlpHeader.getRlpList().get(2)).getRawData());
        result.setStateRoot(((RLPElement)rlpHeader.getRlpList().get(3)).getRawData());
        result.setTxTrieRoot(((RLPElement)rlpHeader.getRlpList().get(4)).getRawData());
        result.setReceiptTrieRoot(((RLPElement)rlpHeader.getRlpList().get(5)).getRawData());
        result.setLogsBloom(((RLPElement)rlpHeader.getRlpList().get(6)).getRawData());
        result.setDifficulty(((RLPElement)rlpHeader.getRlpList().get(7)).getRawData());
        result.setNumberRaw(((RLPElement)rlpHeader.getRlpList().get(8)).getRawData());
        result.setGasLimitRaw(((RLPElement)rlpHeader.getRlpList().get(9)).getRawData());
        result.setGasUsedRaw(((RLPElement)rlpHeader.getRlpList().get(10)).getRawData());
        result.setTimestamp(EthereumUtil.convertVarNumberToLong((RLPElement)rlpHeader.getRlpList().get(11)));
        result.setExtraData(((RLPElement)rlpHeader.getRlpList().get(12)).getRawData());
        result.setMixHash(((RLPElement)rlpHeader.getRlpList().get(13)).getRawData());
        result.setNonce(((RLPElement)rlpHeader.getRlpList().get(14)).getRawData());
        return result;
    }

    private List<EthereumTransaction> parseRLPTransactions(RLPList rlpTransactions) {
        ArrayList<EthereumTransaction> result = new ArrayList<EthereumTransaction>(rlpTransactions.getRlpList().size());
        for (int i = 0; i < rlpTransactions.getRlpList().size(); ++i) {
            RLPList currenTransactionRLP = (RLPList)rlpTransactions.getRlpList().get(i);
            EthereumTransaction currentTransaction = new EthereumTransaction();
            currentTransaction.setNonce(((RLPElement)currenTransactionRLP.getRlpList().get(0)).getRawData());
            currentTransaction.setGasPriceRaw(((RLPElement)currenTransactionRLP.getRlpList().get(1)).getRawData());
            currentTransaction.setGasLimitRaw(((RLPElement)currenTransactionRLP.getRlpList().get(2)).getRawData());
            currentTransaction.setReceiveAddress(((RLPElement)currenTransactionRLP.getRlpList().get(3)).getRawData());
            currentTransaction.setValueRaw(((RLPElement)currenTransactionRLP.getRlpList().get(4)).getRawData());
            currentTransaction.setData(((RLPElement)currenTransactionRLP.getRlpList().get(5)).getRawData());
            if (((RLPElement)currenTransactionRLP.getRlpList().get(6)).getRawData().length > 0) {
                currentTransaction.setSig_v(((RLPElement)currenTransactionRLP.getRlpList().get(6)).getRawData());
                currentTransaction.setSig_r(((RLPElement)currenTransactionRLP.getRlpList().get(7)).getRawData());
                currentTransaction.setSig_s(((RLPElement)currenTransactionRLP.getRlpList().get(8)).getRawData());
            }
            result.add(currentTransaction);
        }
        return result;
    }

    private List<EthereumBlockHeader> parseRLPUncleHeaders(RLPList rlpUncles) {
        ArrayList<EthereumBlockHeader> result = new ArrayList<EthereumBlockHeader>(rlpUncles.getRlpList().size());
        for (int i = 0; i < rlpUncles.getRlpList().size(); ++i) {
            RLPList currentUncleRLP = (RLPList)rlpUncles.getRlpList().get(i);
            EthereumBlockHeader currentUncle = this.parseRLPBlockHeader(currentUncleRLP);
            result.add(currentUncle);
        }
        return result;
    }

    public ByteBuffer readRawBlock() throws IOException, EthereumBlockReadException {
        int readByte;
        ByteBuffer result = null;
        this.in.mark(10);
        byte[] listHeader = new byte[10];
        int totalRead = 0;
        int bRead = this.in.read(listHeader);
        if (bRead == -1) {
            return result;
        }
        totalRead += bRead;
        while (totalRead < 10) {
            bRead = this.in.read(listHeader, totalRead, 10 - totalRead);
            if (bRead == -1) {
                throw new EthereumBlockReadException("Error: Not enough block data available: " + String.valueOf(bRead));
            }
            totalRead += bRead;
        }
        ByteBuffer sizeByteBuffer = ByteBuffer.wrap(listHeader);
        long blockSize = EthereumUtil.getRLPListSize(sizeByteBuffer);
        this.in.reset();
        if (blockSize == 0L) {
            throw new EthereumBlockReadException("Error: Blocksize too small");
        }
        if (blockSize < 0L) {
            throw new EthereumBlockReadException("Error: This block size cannot be handled currently (larger then largest number in positive signed int)");
        }
        if (blockSize > (long)this.maxSizeEthereumBlock) {
            throw new EthereumBlockReadException("Error: Block size is larger then defined in configuration - Please increase it if this is a valid block");
        }
        int blockSizeInt = (int)blockSize;
        byte[] fullBlock = new byte[blockSizeInt];
        int totalByteRead = 0;
        while ((readByte = this.in.read(fullBlock, totalByteRead, blockSizeInt - totalByteRead)) > -1 && (long)(totalByteRead += readByte) < blockSize) {
        }
        if ((long)totalByteRead != blockSize) {
            throw new EthereumBlockReadException("Error: Could not read full block");
        }
        if (!this.useDirectBuffer) {
            result = ByteBuffer.wrap(fullBlock);
        } else {
            this.preAllocatedDirectByteBuffer.clear();
            this.preAllocatedDirectByteBuffer.limit(fullBlock.length);
            result = this.preAllocatedDirectByteBuffer;
            result.put(fullBlock);
            result.flip();
        }
        result.order(ByteOrder.LITTLE_ENDIAN);
        return result;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

