/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.hadoop.io.Writable;
import org.zuinnote.hadoop.ethereum.format.common.EthereumUtil;

public class EthereumTransaction
implements Writable,
Serializable {
    private byte[] nonce;
    private BigInteger value;
    private byte[] valueRaw;
    private byte[] receiveAddress;
    private BigInteger gasPrice;
    private byte[] gasPriceRaw;
    private BigInteger gasLimit;
    private byte[] gasLimitRaw;
    private byte[] data;
    private byte[] sig_v;
    private byte[] sig_r;
    private byte[] sig_s;

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("write unsupported");
    }

    public void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException("readFields unsupported");
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public BigInteger getValue() {
        if (this.value == null) {
            this.value = EthereumUtil.convertVarNumberToBigInteger(this.valueRaw);
        }
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public byte[] getReceiveAddress() {
        return this.receiveAddress;
    }

    public void setReceiveAddress(byte[] receiveAddress) {
        this.receiveAddress = receiveAddress;
    }

    public BigInteger getGasPrice() {
        if (this.gasPrice == null) {
            this.gasPrice = EthereumUtil.convertVarNumberToBigInteger(this.gasPriceRaw);
        }
        return this.gasPrice;
    }

    public void setGasPrice(BigInteger gasPrice) {
        this.gasPrice = gasPrice;
    }

    public BigInteger getGasLimit() {
        if (this.gasLimit == null) {
            this.gasLimit = EthereumUtil.convertVarNumberToBigInteger(this.gasLimitRaw);
        }
        return this.gasLimit;
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void set(EthereumTransaction newTransaction) {
        this.nonce = newTransaction.getNonce();
        this.valueRaw = newTransaction.getValueRaw();
        this.value = newTransaction.getValue();
        this.receiveAddress = newTransaction.getReceiveAddress();
        this.gasPriceRaw = newTransaction.getGasPriceRaw();
        this.gasPrice = newTransaction.getGasPrice();
        this.gasLimitRaw = newTransaction.getGasLimitRaw();
        this.gasLimit = newTransaction.getGasLimit();
        this.data = newTransaction.getData();
        this.sig_v = newTransaction.getSig_v();
        this.sig_r = newTransaction.getSig_r();
        this.sig_s = newTransaction.getSig_s();
    }

    public byte[] getSig_v() {
        return this.sig_v;
    }

    public void setSig_v(byte[] sig_v) {
        this.sig_v = sig_v;
    }

    public byte[] getSig_r() {
        return this.sig_r;
    }

    public void setSig_r(byte[] sig_r) {
        this.sig_r = sig_r;
    }

    public byte[] getSig_s() {
        return this.sig_s;
    }

    public void setSig_s(byte[] sig_s) {
        this.sig_s = sig_s;
    }

    public byte[] getValueRaw() {
        return this.valueRaw;
    }

    public void setValueRaw(byte[] valueRaw) {
        this.valueRaw = valueRaw;
    }

    public byte[] getGasPriceRaw() {
        return this.gasPriceRaw;
    }

    public void setGasPriceRaw(byte[] gasPriceRaw) {
        this.gasPriceRaw = gasPriceRaw;
    }

    public byte[] getGasLimitRaw() {
        return this.gasLimitRaw;
    }

    public void setGasLimitRaw(byte[] gasLimitRaw) {
        this.gasLimitRaw = gasLimitRaw;
    }
}

