/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.common;

import hadoopcryptoledger.shade.org.bouncycastle.asn1.sec.SECNamedCurves;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.x9.X9ECParameters;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.x9.X9IntegerConverter;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ECDomainParameters;
import hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.digest.Keccak;
import hadoopcryptoledger.shade.org.bouncycastle.math.ec.ECAlgorithms;
import hadoopcryptoledger.shade.org.bouncycastle.math.ec.ECCurve;
import hadoopcryptoledger.shade.org.bouncycastle.math.ec.ECPoint;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuinnote.hadoop.ethereum.format.common.EthereumTransaction;
import org.zuinnote.hadoop.ethereum.format.common.rlp.RLPElement;
import org.zuinnote.hadoop.ethereum.format.common.rlp.RLPList;
import org.zuinnote.hadoop.ethereum.format.common.rlp.RLPObject;

public class EthereumUtil {
    public static final int RLP_OBJECTTYPE_INVALID = -1;
    public static final int RLP_OBJECTTYPE_ELEMENT = 0;
    public static final int RLP_OBJECTTYPE_LIST = 1;
    public static final int CHAIN_ID_INC = 35;
    public static final int LOWER_REAL_V = 27;
    public static final int HASH_SIZE = 256;
    public static final int LONG_SIZE = 8;
    public static final int INT_SIZE = 4;
    public static final int WORD_SIZE = 2;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Log LOG = LogFactory.getLog((String)EthereumUtil.class.getName());

    public static RLPObject rlpDecodeNextItem(ByteBuffer bb) {
        RLPObject result = null;
        int objType = EthereumUtil.detectRLPObjectType(bb);
        switch (objType) {
            case 0: {
                result = EthereumUtil.decodeRLPElement(bb);
                break;
            }
            case 1: {
                result = EthereumUtil.decodeRLPList(bb);
                break;
            }
            default: {
                LOG.error((Object)"Unknown object type");
            }
        }
        return result;
    }

    public static int detectRLPObjectType(ByteBuffer bb) {
        bb.mark();
        byte detector = bb.get();
        int unsignedDetector = detector & 0xFF;
        int result = -1;
        if (unsignedDetector <= 127) {
            result = 0;
        } else if (unsignedDetector >= 128 && unsignedDetector <= 183) {
            result = 0;
        } else if (unsignedDetector >= 184 && unsignedDetector <= 191) {
            result = 0;
        } else if (unsignedDetector >= 192 && unsignedDetector <= 247) {
            result = 1;
        } else if (unsignedDetector >= 248 && unsignedDetector <= 255) {
            result = 1;
        } else {
            result = -1;
            LOG.error((Object)"Invalid RLP object type. Internal error or not RLP Data");
        }
        bb.reset();
        return result;
    }

    private static long convertIndicatorToRLPSize(byte[] indicator) {
        byte[] rawDataNumber = Arrays.copyOfRange(indicator, 1, indicator.length);
        ArrayUtils.reverse((byte[])rawDataNumber);
        long RLPSize = 0L;
        for (int i = 0; i < rawDataNumber.length; ++i) {
            RLPSize = (long)((double)RLPSize + (double)(rawDataNumber[i] & 0xFF) * Math.pow(256.0, i));
        }
        return RLPSize;
    }

    private static RLPElement decodeRLPElement(ByteBuffer bb) {
        RLPElement result = null;
        byte firstByte = bb.get();
        int firstByteUnsigned = firstByte & 0xFF;
        if (firstByteUnsigned <= 127) {
            result = new RLPElement(new byte[]{firstByte}, new byte[]{firstByte});
        } else if (firstByteUnsigned >= 128 && firstByteUnsigned <= 183) {
            byte[] indicator = new byte[]{firstByte};
            int noOfBytes = firstByteUnsigned - 128;
            byte[] rawData = new byte[noOfBytes];
            if (noOfBytes > 0) {
                bb.get(rawData);
            }
            result = new RLPElement(indicator, rawData);
        } else if (firstByteUnsigned >= 184 && firstByteUnsigned <= 191) {
            int NoOfBytesSize = firstByteUnsigned - 183;
            byte[] indicator = new byte[NoOfBytesSize + 1];
            indicator[0] = firstByte;
            bb.get(indicator, 1, NoOfBytesSize);
            long noOfBytes = EthereumUtil.convertIndicatorToRLPSize(indicator);
            byte[] rawData = new byte[(int)noOfBytes];
            bb.get(rawData);
            result = new RLPElement(indicator, rawData);
        } else {
            result = null;
        }
        return result;
    }

    public static byte[] encodeRLPElement(byte[] rawData) {
        byte[] result = null;
        if (rawData == null || rawData.length == 0) {
            return new byte[]{-128};
        }
        if (rawData.length <= 55) {
            if (rawData.length == 1 && (rawData[0] & 0xFF) <= 127) {
                return new byte[]{rawData[0]};
            }
            result = new byte[rawData.length + 1];
            result[0] = (byte)(128 + rawData.length);
            for (int i = 0; i < rawData.length; ++i) {
                result[i + 1] = rawData[i];
            }
        } else {
            int i;
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(rawData.length);
            byte[] intArray = bb.array();
            int intSize = 0;
            for (int i2 = 0; i2 < intArray.length && intArray[i2] != 0; ++i2) {
                ++intSize;
            }
            result = new byte[1 + intSize + rawData.length];
            result[0] = (byte)(183 + intSize);
            byte[] rawDataNumber = Arrays.copyOfRange(intArray, 0, intSize);
            ArrayUtils.reverse((byte[])rawDataNumber);
            for (i = 0; i < rawDataNumber.length; ++i) {
                result[1 + i] = rawDataNumber[i];
            }
            for (i = 0; i < rawData.length; ++i) {
                result[1 + intSize + i] = rawData[i];
            }
        }
        return result;
    }

    private static byte[] encodeRLPList(List<byte[]> rawElementList) {
        byte[] result;
        int totalSize = 0;
        if (rawElementList == null || rawElementList.size() == 0) {
            return new byte[]{-64};
        }
        for (int i = 0; i < rawElementList.size(); ++i) {
            totalSize += rawElementList.get(i).length;
        }
        int currentPosition = 0;
        if (totalSize <= 55) {
            result = new byte[1 + totalSize];
            result[0] = (byte)(192 + totalSize);
            currentPosition = 1;
        } else {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(totalSize);
            byte[] intArray = bb.array();
            int intSize = 0;
            for (int i = 0; i < intArray.length && intArray[i] != 0; ++i) {
                ++intSize;
            }
            result = new byte[1 + intSize + totalSize];
            result[0] = (byte)(247 + intSize);
            byte[] rawDataNumber = Arrays.copyOfRange(intArray, 0, intSize);
            ArrayUtils.reverse((byte[])rawDataNumber);
            for (int i = 0; i < rawDataNumber.length; ++i) {
                result[1 + i] = rawDataNumber[i];
            }
            currentPosition = 1 + intSize;
        }
        for (int i = 0; i < rawElementList.size(); ++i) {
            byte[] currentElement = rawElementList.get(i);
            for (int j = 0; j < currentElement.length; ++j) {
                result[currentPosition] = currentElement[j];
                ++currentPosition;
            }
        }
        return result;
    }

    public static long getRLPListSize(ByteBuffer bb) {
        long result = -1L;
        bb.mark();
        byte detector = bb.get();
        int unsignedDetector = detector & 0xFF;
        if (unsignedDetector >= 192 && unsignedDetector <= 247) {
            result = unsignedDetector;
        } else if (unsignedDetector >= 248 && unsignedDetector <= 255) {
            int noOfBytesSize = unsignedDetector - 247;
            byte[] indicator = new byte[noOfBytesSize + 1];
            indicator[0] = detector;
            bb.get(indicator, 1, noOfBytesSize);
            result = (long)indicator.length + EthereumUtil.convertIndicatorToRLPSize(indicator);
        }
        bb.reset();
        return result;
    }

    private static RLPList decodeRLPList(ByteBuffer bb) {
        byte firstByte = bb.get();
        int firstByteUnsigned = firstByte & 0xFF;
        long payloadSize = -1L;
        if (firstByteUnsigned >= 192 && firstByteUnsigned <= 247) {
            int offsetSmallList = 192;
            payloadSize = (long)firstByteUnsigned - (long)offsetSmallList;
        } else if (firstByteUnsigned >= 248 && firstByteUnsigned <= 255) {
            int noOfBytesSize = firstByteUnsigned - 247;
            byte[] indicator = new byte[noOfBytesSize + 1];
            indicator[0] = firstByte;
            bb.get(indicator, 1, noOfBytesSize);
            payloadSize = EthereumUtil.convertIndicatorToRLPSize(indicator);
        } else {
            LOG.error((Object)"Invalid RLP encoded list detected");
        }
        ArrayList<RLPObject> payloadList = new ArrayList<RLPObject>();
        if (payloadSize > 0L) {
            byte[] payload = new byte[(int)payloadSize];
            bb.get(payload);
            ByteBuffer payloadBB = ByteBuffer.wrap(payload);
            block4: while (payloadBB.remaining() > 0) {
                switch (EthereumUtil.detectRLPObjectType(payloadBB)) {
                    case 0: {
                        payloadList.add(EthereumUtil.decodeRLPElement(payloadBB));
                        continue block4;
                    }
                    case 1: {
                        payloadList.add(EthereumUtil.decodeRLPList(payloadBB));
                        continue block4;
                    }
                }
                LOG.error((Object)"Unknown object type");
            }
        }
        return new RLPList(payloadList);
    }

    public static Long calculateChainId(EthereumTransaction eTrans) {
        Long result = null;
        long rawResult = EthereumUtil.convertVarNumberToLong(new RLPElement(new byte[0], eTrans.getSig_v()));
        if (rawResult != 27L && rawResult != 28L) {
            result = (rawResult - 35L) / 2L;
        }
        return result;
    }

    public static byte[] getTransactionHash(EthereumTransaction eTrans) {
        ArrayList<byte[]> rlpTransaction = new ArrayList<byte[]>();
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getNonce()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getGasPriceRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getGasLimitRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getReceiveAddress()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getValueRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getData()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getSig_v()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getSig_r()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getSig_s()));
        byte[] transEnc = EthereumUtil.encodeRLPList(rlpTransaction);
        Keccak.Digest256 digest = new Keccak.Digest256();
        digest.update(transEnc, 0, transEnc.length);
        return digest.digest();
    }

    public static byte[] getTransactionHashWithoutSignature(EthereumTransaction eTrans) {
        ArrayList<byte[]> rlpTransaction = new ArrayList<byte[]>();
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getNonce()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getGasPriceRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getGasLimitRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getReceiveAddress()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getValueRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getData()));
        byte[] transEnc = EthereumUtil.encodeRLPList(rlpTransaction);
        Keccak.Digest256 digest = new Keccak.Digest256();
        digest.update(transEnc, 0, transEnc.length);
        return digest.digest();
    }

    public static byte[] getTransactionHashWithDummySignatureEIP155(EthereumTransaction eTrans) {
        ArrayList<byte[]> rlpTransaction = new ArrayList<byte[]>();
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getNonce()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getGasPriceRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getGasLimitRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getReceiveAddress()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getValueRaw()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(eTrans.getData()));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(new byte[]{(byte)((eTrans.getSig_v()[0] - 35) / 2)}));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(EMPTY_BYTE_ARRAY));
        rlpTransaction.add(EthereumUtil.encodeRLPElement(EMPTY_BYTE_ARRAY));
        byte[] transEnc = EthereumUtil.encodeRLPList(rlpTransaction);
        Keccak.Digest256 digest = new Keccak.Digest256();
        digest.update(transEnc, 0, transEnc.length);
        return digest.digest();
    }

    public static byte[] getSendAddress(EthereumTransaction eTrans, int chainId) {
        ECCurve.Fp curve;
        BigInteger prime;
        X9ECParameters params = SECNamedCurves.getByName("secp256k1");
        ECDomainParameters CURVE = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
        byte[] transactionHash = eTrans.getSig_v()[0] == chainId * 2 + 35 || eTrans.getSig_v()[0] == chainId * 2 + 35 + 1 ? EthereumUtil.getTransactionHashWithDummySignatureEIP155(eTrans) : EthereumUtil.getTransactionHashWithoutSignature(eTrans);
        BigInteger bR = new BigInteger(1, eTrans.getSig_r());
        BigInteger bS = new BigInteger(1, eTrans.getSig_s());
        int v = eTrans.getSig_v()[0];
        if (v != 27 && v != 28) {
            int vReal = 27;
            v = v % 2 == 0 ? (int)((byte)(vReal + 1)) : vReal;
        }
        if (v < 27 || v > 34) {
            LOG.error((Object)("Header out of Range:  " + v));
            throw new RuntimeException("Header out of range " + v);
        }
        if (v >= 31) {
            v = (byte)(v - 4);
        }
        int receiverId = v - 27;
        BigInteger n = CURVE.getN();
        BigInteger i = BigInteger.valueOf((long)receiverId / 2L);
        BigInteger x = bR.add(i.multiply(n));
        if (x.compareTo(prime = (curve = (ECCurve.Fp)CURVE.getCurve()).getQ()) >= 0) {
            return null;
        }
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(x, 1 + x9.getByteLength(CURVE.getCurve()));
        boolean yBit = (receiverId & 1) == 1;
        compEnc[0] = (byte)(yBit ? 3 : 2);
        ECPoint R = CURVE.getCurve().decodePoint(compEnc);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, transactionHash);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = bR.modInverse(n);
        BigInteger srInv = rInv.multiply(bS).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint.Fp q = (ECPoint.Fp)ECAlgorithms.sumOfTwoMultiplies(CURVE.getG(), eInvrInv, R, srInv);
        byte[] pubKey = q.getEncoded(false);
        Keccak.Digest256 digest256 = new Keccak.Digest256();
        digest256.update(pubKey, 1, pubKey.length - 1);
        byte[] kcck = digest256.digest();
        return Arrays.copyOfRange(kcck, 12, kcck.length);
    }

    public static BigInteger convertVarNumberToBigInteger(RLPElement rpe) {
        return EthereumUtil.convertVarNumberToBigInteger(rpe.getRawData());
    }

    public static BigInteger convertVarNumberToBigInteger(byte[] rawData) {
        BigInteger result = BigInteger.ZERO;
        if (rawData != null && rawData.length > 0) {
            result = new BigInteger(1, rawData);
        }
        return result;
    }

    public static Long convertVarNumberToLong(RLPElement rpe) {
        Long result = 0L;
        if (rpe.getRawData() != null) {
            if (rpe.getRawData().length == 0) {
                result = 0L;
            } else if (rpe.getRawData().length < 2) {
                result = (long)EthereumUtil.convertToByte(rpe);
            } else if (rpe.getRawData().length < 3) {
                result = (long)EthereumUtil.convertToShort(rpe);
            } else if (rpe.getRawData().length < 5) {
                result = (long)EthereumUtil.convertToInt(rpe);
            } else if (rpe.getRawData().length < 9) {
                result = EthereumUtil.convertToLong(rpe);
            }
        }
        return result;
    }

    public static Short convertToByte(RLPElement rpe) {
        Short result = 0;
        if (rpe.getRawData() != null || rpe.getRawData().length == 1) {
            result = (short)(rpe.getRawData()[0] & 0xFF);
        }
        return result;
    }

    public static Integer convertToShort(RLPElement rpe) {
        Integer result = 0;
        byte[] rawBytes = rpe.getRawData();
        if (rawBytes != null) {
            if (rawBytes.length < 2) {
                byte[] fullBytes = new byte[2];
                int dtDiff = 2 - rawBytes.length;
                for (int i = 0; i < rawBytes.length; ++i) {
                    fullBytes[dtDiff + i] = rawBytes[i];
                    result = ByteBuffer.wrap(fullBytes).getShort() & 0xFFFF;
                }
            } else {
                result = ByteBuffer.wrap(rawBytes).getShort() & 0xFFFF;
            }
        }
        return result;
    }

    public static Long convertToInt(RLPElement rpe) {
        Long result = 0L;
        byte[] rawBytes = rpe.getRawData();
        if (rawBytes != null) {
            if (rawBytes.length < 4) {
                byte[] fullBytes = new byte[4];
                int dtDiff = 4 - rawBytes.length;
                for (int i = 0; i < rawBytes.length; ++i) {
                    fullBytes[dtDiff + i] = rawBytes[i];
                    result = (long)ByteBuffer.wrap(fullBytes).getInt() & 0xFFFFFFFFL;
                }
            } else {
                result = (long)ByteBuffer.wrap(rawBytes).getInt() & 0xFFFFFFFFL;
            }
        }
        return result;
    }

    public static Long convertToLong(RLPElement rpe) {
        Long result = 0L;
        byte[] rawBytes = rpe.getRawData();
        if (rawBytes != null) {
            if (rawBytes.length < 8) {
                byte[] fullBytes = new byte[8];
                int dtDiff = 8 - rawBytes.length;
                for (int i = 0; i < rawBytes.length; ++i) {
                    fullBytes[dtDiff + i] = rawBytes[i];
                    result = ByteBuffer.wrap(fullBytes).getLong();
                }
            } else {
                result = ByteBuffer.wrap(rawBytes).getLong();
            }
        }
        return result;
    }

    @Deprecated
    public static byte[] convertLongToVarInt(long value) {
        ByteBuffer longBB = ByteBuffer.allocate(8);
        longBB.putLong(value);
        byte[] result = longBB.array();
        int leadingZeros = 0;
        for (int i = 0; i < result.length && result[i] == 0; ++i) {
            ++leadingZeros;
        }
        return Arrays.copyOfRange(result, leadingZeros, result.length);
    }

    public static String convertToString(RLPElement rpe) throws UnsupportedEncodingException {
        String result = null;
        if (rpe.getRawData() != null && rpe.getRawData().length != 0) {
            result = new String(rpe.getRawData(), "UTF-8");
        }
        return result;
    }

    public static String convertToString(RLPElement rpe, String encoding) throws UnsupportedEncodingException {
        String result = null;
        if (rpe.getRawData() != null && rpe.getRawData().length != 0) {
            result = new String(rpe.getRawData(), encoding);
        }
        return result;
    }

    public static byte[] convertHexStringToByteArray(String hexString) {
        return DatatypeConverter.parseHexBinary((String)hexString);
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        return DatatypeConverter.printHexBinary((byte[])byteArray);
    }

    public static byte[] reverseByteArray(byte[] inputByteArray) {
        byte[] result = new byte[inputByteArray.length];
        for (int i = inputByteArray.length - 1; i >= 0; --i) {
            result[result.length - 1 - i] = inputByteArray[i];
        }
        return result;
    }
}

