/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.ethereum.format.common.EthereumBlock;
import org.zuinnote.hadoop.ethereum.format.exception.EthereumBlockReadException;
import org.zuinnote.hadoop.ethereum.format.mapred.AbstractEthereumRecordReader;

public class EthereumBlockRecordReader
extends AbstractEthereumRecordReader<BytesWritable, EthereumBlock> {
    private static final Log LOG = LogFactory.getLog((String)EthereumBlockRecordReader.class.getName());

    public EthereumBlockRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException {
        super(split, job, reporter);
    }

    public boolean next(BytesWritable key, EthereumBlock value) throws IOException {
        if (this.getFilePosition() <= this.getEnd()) {
            EthereumBlock dataBlock = null;
            try {
                dataBlock = this.getEbr().readBlock();
            }
            catch (EthereumBlockReadException e) {
                LOG.error((Object)e);
                throw new RuntimeException(e.toString());
            }
            if (dataBlock == null) {
                return false;
            }
            byte[] newKey = dataBlock.getEthereumBlockHeader().getParentHash();
            key.set(newKey, 0, newKey.length);
            value.set(dataBlock);
            return true;
        }
        return false;
    }

    public BytesWritable createKey() {
        return new BytesWritable();
    }

    public EthereumBlock createValue() {
        return new EthereumBlock();
    }
}

