/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.zuinnote.hadoop.ethereum.format.common.EthereumBlockReader;

public abstract class AbstractEthereumRecordReader<K, V>
extends RecordReader<K, V> {
    public static final String CONF_BUFFERSIZE = "io.file.buffer.size";
    public static final String CONF_MAXBLOCKSIZE = "hadoopcryptoledger.ethereumblockinputformat.maxblocksize";
    public static final String CONF_USEDIRECTBUFFER = "hadoopcryptoledeger.ethereumblockinputformat.usedirectbuffer";
    public static final int DEFAULT_BUFFERSIZE = 65536;
    public static final int DEFAULT_MAXSIZE_ETHEREUMBLOCK = 0x100000;
    public static final boolean DEFAULT_USEDIRECTBUFFER = false;
    private static final Log LOG = LogFactory.getLog((String)AbstractEthereumRecordReader.class.getName());
    private int bufferSize = 0;
    private int maxSizeEthereumBlock = 0;
    private boolean useDirectBuffer = false;
    private CompressionCodec codec;
    private Decompressor decompressor;
    private long start;
    private long end;
    private Seekable filePosition;
    private EthereumBlockReader ebr;

    public AbstractEthereumRecordReader(Configuration conf) {
        this.maxSizeEthereumBlock = conf.getInt(CONF_MAXBLOCKSIZE, 0x100000);
        this.bufferSize = conf.getInt(CONF_BUFFERSIZE, 65536);
        this.useDirectBuffer = conf.getBoolean(CONF_USEDIRECTBUFFER, false);
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fSplit = (FileSplit)split;
        this.start = fSplit.getStart();
        this.end = this.start + fSplit.getLength();
        Path file = fSplit.getPath();
        this.codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        FSDataInputStream fileIn = fs.open(file);
        if (this.isCompressedInput()) {
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)this.codec);
            if (this.codec instanceof SplittableCompressionCodec) {
                SplitCompressionInputStream cIn = ((SplittableCompressionCodec)this.codec).createInputStream((InputStream)fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.CONTINUOUS);
                this.ebr = new EthereumBlockReader((InputStream)cIn, this.maxSizeEthereumBlock, this.bufferSize, this.useDirectBuffer);
                this.start = cIn.getAdjustedStart();
                this.end = cIn.getAdjustedEnd();
                this.filePosition = cIn;
            } else {
                this.ebr = new EthereumBlockReader((InputStream)this.codec.createInputStream((InputStream)fileIn, this.decompressor), this.maxSizeEthereumBlock, this.bufferSize, this.useDirectBuffer);
                this.filePosition = fileIn;
            }
        } else {
            fileIn.seek(this.start);
            this.ebr = new EthereumBlockReader((InputStream)fileIn, this.maxSizeEthereumBlock, this.bufferSize, this.useDirectBuffer);
            this.filePosition = fileIn;
        }
    }

    public EthereumBlockReader getEbr() {
        return this.ebr;
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    public long getEnd() {
        return this.end;
    }

    public long getFilePosition() throws IOException {
        return this.filePosition.getPos();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.ebr != null) {
                this.ebr.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }

    private boolean isCompressedInput() {
        return this.codec != null;
    }
}

