/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class HadoopUtil {
    private HadoopUtil() {
    }

    public static Map<String, String> parsePropertiesFromBase(Configuration conf, String base) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry currentItem : conf) {
            String currentKey = (String)currentItem.getKey();
            if (!currentKey.startsWith(base)) continue;
            String strippedKey = currentKey.substring(base.length());
            result.put(strippedKey, (String)currentItem.getValue());
        }
        return result;
    }

    public static DataOutputStream getDataOutputStream(Configuration conf, Path file, Progressable progress, boolean compressed, Class<? extends CompressionCodec> compressorClass) throws IOException {
        if (!compressed) {
            FileSystem fs = file.getFileSystem(conf);
            return fs.create(file, progress);
        }
        Class<? extends CompressionCodec> codecClass = compressorClass;
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
        Path compressedFile = file.suffix(codec.getDefaultExtension());
        FileSystem fs = compressedFile.getFileSystem(conf);
        return new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fs.create(compressedFile, progress)));
    }

    public static String[] parseLinkedWorkbooks(String linkedWorkbooksString) {
        if ("".equals(linkedWorkbooksString)) {
            return new String[0];
        }
        String[] tempSplit = linkedWorkbooksString.split("\\]:\\[");
        if (tempSplit.length == 1) {
            tempSplit[0] = tempSplit[0].substring(1, tempSplit[0].length() - 1);
        } else if (tempSplit.length > 1) {
            tempSplit[0] = tempSplit[0].substring(1, tempSplit[0].length());
            tempSplit[tempSplit.length - 1] = tempSplit[tempSplit.length - 1].substring(0, tempSplit[tempSplit.length - 1].length() - 1);
        }
        return tempSplit;
    }
}

