/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.dao;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class SpreadSheetCellDAO
implements Writable,
Serializable {
    private static final long serialVersionUID = -1687737381474332741L;
    private String formattedValue;
    private String comment;
    private String formula;
    private String address;
    private String sheetName;

    public SpreadSheetCellDAO() {
        this.formattedValue = "";
        this.comment = "";
        this.formula = "";
        this.address = "";
        this.sheetName = "";
    }

    public SpreadSheetCellDAO(String formattedValue, String comment, String formula, String address, String sheetName) {
        this.formattedValue = formattedValue;
        this.comment = comment;
        this.formula = formula;
        this.address = address;
        this.sheetName = sheetName;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getAddress() {
        return this.address;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void set(SpreadSheetCellDAO newSpreadSheetCellDAO) {
        this.formattedValue = newSpreadSheetCellDAO.getFormattedValue();
        this.comment = newSpreadSheetCellDAO.getComment();
        this.formula = newSpreadSheetCellDAO.getFormula();
        this.address = newSpreadSheetCellDAO.getAddress();
        this.sheetName = newSpreadSheetCellDAO.getSheetName();
    }

    public void write(DataOutput dataOutput) throws IOException {
        Text formattedValueText = new Text("");
        if (this.formattedValue != null) {
            formattedValueText = new Text(this.formattedValue);
        }
        Text commentText = new Text("");
        if (this.comment != null) {
            commentText = new Text(this.comment);
        }
        Text formulaText = new Text("");
        if (this.formula != null) {
            formulaText = new Text(this.formula);
        }
        Text addressText = new Text("");
        if (this.address != null) {
            addressText = new Text(this.address);
        }
        Text sheetNameText = new Text("");
        if (this.sheetName != null) {
            sheetNameText = new Text(this.sheetName);
        }
        formattedValueText.write(dataOutput);
        commentText.write(dataOutput);
        formulaText.write(dataOutput);
        addressText.write(dataOutput);
        sheetNameText.write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        Text formattedValueText = (Text)WritableFactories.newInstance(Text.class);
        formattedValueText.readFields(dataInput);
        this.formattedValue = formattedValueText.toString();
        Text commentText = (Text)WritableFactories.newInstance(Text.class);
        commentText.readFields(dataInput);
        this.comment = commentText.toString();
        Text formulaText = (Text)WritableFactories.newInstance(Text.class);
        formulaText.readFields(dataInput);
        this.formula = formulaText.toString();
        Text addressText = (Text)WritableFactories.newInstance(Text.class);
        addressText.readFields(dataInput);
        this.address = addressText.toString();
        Text sheetNameText = (Text)WritableFactories.newInstance(Text.class);
        sheetNameText.readFields(dataInput);
        this.sheetName = sheetNameText.toString();
    }
}

