/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.writer.msexcel.internal;

import hadoopoffice.shade.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import hadoopoffice.shade.org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import hadoopoffice.shade.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import hadoopoffice.shade.org.apache.commons.compress.archivers.zip.ZipFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.util.TempFile;

public class EncryptedZipEntrySource
implements ZipEntrySource {
    private static final Log LOG = LogFactory.getLog((String)EncryptedZipEntrySource.class.getName());
    private ZipFile zipFile;
    private CipherAlgorithm ca;
    private ChainingMode cm;
    private Cipher ciEncoder;
    private Cipher ciDecoder;
    private File tmpFile;
    private boolean closed;

    public EncryptedZipEntrySource(CipherAlgorithm ca, ChainingMode cm) throws IOException {
        if (ca != null) {
            SecureRandom sr = new SecureRandom();
            byte[] iv = new byte[ca.blockSize];
            byte[] key = new byte[ca.defaultKeySize / 8];
            sr.nextBytes(iv);
            sr.nextBytes(key);
            SecretKeySpec skeySpec = new SecretKeySpec(key, ca.jceId);
            this.ca = ca;
            this.cm = cm;
            this.ciEncoder = CryptoFunctions.getCipher(skeySpec, ca, cm, iv, 1, "PKCS5Padding");
            this.ciDecoder = CryptoFunctions.getCipher(skeySpec, ca, cm, iv, 2, "PKCS5Padding");
        }
        this.closed = false;
    }

    public void setInputStream(InputStream is) throws IOException {
        ZipArchiveEntry ze;
        this.tmpFile = TempFile.createTempFile("hadoopoffice-protected", ".zip");
        ZipArchiveInputStream zis = new ZipArchiveInputStream(is);
        FileOutputStream fos = new FileOutputStream(this.tmpFile);
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(fos);
        while ((ze = (ZipArchiveEntry)zis.getNextEntry()) != null) {
            ZipArchiveEntry zeNew = new ZipArchiveEntry(ze.getName());
            zeNew.setComment(ze.getComment());
            zeNew.setExtra(ze.getExtra());
            zeNew.setTime(ze.getTime());
            zos.putArchiveEntry(zeNew);
            FilterOutputStream fos2 = new FilterOutputStream(zos){

                @Override
                public void close() {
                }
            };
            FilterOutputStream nos = this.ciEncoder != null ? new CipherOutputStream(fos2, this.ciEncoder) : fos2;
            IOUtils.copy((InputStream)zis, (OutputStream)nos);
            ((OutputStream)nos).close();
            if (fos2 != null) {
                fos2.close();
            }
            zos.closeArchiveEntry();
        }
        zos.close();
        fos.close();
        zis.close();
        IOUtils.closeQuietly((InputStream)is);
        this.zipFile = new ZipFile(this.tmpFile);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.zipFile.close();
            if (this.tmpFile != null && !this.tmpFile.delete()) {
                LOG.warn((Object)"Could not delete temporary files");
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public ZipArchiveEntry getEntry(String path) {
        return this.zipFile.getEntry(path);
    }

    @Override
    public Enumeration<? extends ZipArchiveEntry> getEntries() {
        return this.zipFile.getEntries();
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        InputStream is = this.zipFile.getInputStream(entry);
        if (this.ciDecoder != null) {
            return new CipherInputStream(is, this.ciDecoder);
        }
        return is;
    }
}

