/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.parser.msexcel;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.apache.poi.poifs.crypt.dsig.SignatureInfo;
import org.apache.poi.poifs.crypt.dsig.SignaturePart;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.model.ExternalLinksTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeReadConfiguration;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.parser.OfficeReaderParserInterface;
import org.zuinnote.hadoop.office.format.common.util.CertificateChainVerificationUtil;

public class MSExcelParser
implements OfficeReaderParserInterface {
    private static final String MIMETYPE_EXCEL_BINARY_ID = "ms-excel.sheet.binary";
    private static final String MATCH_ALL = "matchAll";
    private static final String NOT_MATCHING = "Not matching: ";
    private static final String COULD_NOT_RETRIEVE_LINKED_WORKBOOKS_FOR_OLD_EXCEL_FORMAT = "Could not retrieve linked workbooks for old Excel format.";
    private static final Log LOG = LogFactory.getLog((String)MSExcelParser.class.getName());
    public static final String DATE_FORMAT = "hh:mm:ss dd.MM.yyyy";
    public static final int MAX_LINKEDWB_OLDEXCEL = 100;
    private FormulaEvaluator formulaEvaluator;
    private InputStream in;
    private DataFormatter useDataFormatter = null;
    private String[] sheets = null;
    private Workbook currentWorkbook = null;
    private int currentSheet = 0;
    private int sheetsIndex = 0;
    private int currentRow = 0;
    private String currentSheetName = "";
    private HashMap<String, FormulaEvaluator> addedFormulaEvaluators;
    private ArrayList<Workbook> addedWorkbooks;
    private boolean filtered = false;
    private HadoopOfficeReadConfiguration hocr;
    private String[] header;
    private int currentSkipLine = 0;

    public MSExcelParser(HadoopOfficeReadConfiguration hocr) {
        this(hocr, null);
    }

    public MSExcelParser(HadoopOfficeReadConfiguration hocr, String[] sheets) {
        this.sheets = sheets;
        this.hocr = hocr;
        this.useDataFormatter = hocr.getLocale() == null ? (!this.hocr.getEmulateCSV() ? new DataFormatter() : new DataFormatter(true)) : (!this.hocr.getEmulateCSV() ? new DataFormatter(hocr.getLocale()) : new DataFormatter(hocr.getLocale(), true));
        this.addedFormulaEvaluators = new HashMap();
        this.addedWorkbooks = new ArrayList();
    }

    @Override
    public void parse(InputStream in) throws FormatNotUnderstoodException {
        try {
            this.currentWorkbook = WorkbookFactory.create(in, this.hocr.getPassword());
        }
        catch (IOException | EncryptedDocumentException e) {
            LOG.error((Object)e);
            throw new FormatNotUnderstoodException(e.toString());
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }
        if (this.hocr.getVerifySignature()) {
            LOG.info((Object)"Verifying signature of document");
            if (!(this.currentWorkbook instanceof XSSFWorkbook)) {
                throw new FormatNotUnderstoodException("Can only verify signatures for files using the OOXML (.xlsx) format");
            }
            OPCPackage pgk = ((XSSFWorkbook)this.currentWorkbook).getPackage();
            SignatureConfig sic = new SignatureConfig();
            sic.setOpcPackage(pgk);
            SignatureInfo si = new SignatureInfo();
            si.setSignatureConfig(sic);
            if (!si.verifySignature()) {
                throw new FormatNotUnderstoodException("Cannot verify signature of OOXML (.xlsx) file: " + this.hocr.getFileName());
            }
            LOG.info((Object)("Successfully verifed first part signature of OXXML (.xlsx) file: " + this.hocr.getFileName()));
            for (SignaturePart currentSP : si.getSignatureParts()) {
                if (!currentSP.validate()) {
                    throw new FormatNotUnderstoodException("Could not validate all signature parts for file: " + this.hocr.getFileName());
                }
                X509Certificate currentCertificate = currentSP.getSigner();
                try {
                    if (this.hocr.getX509CertificateChain().size() <= 0 || CertificateChainVerificationUtil.verifyCertificateChain(currentCertificate, this.hocr.getX509CertificateChain())) continue;
                    throw new FormatNotUnderstoodException("Could not validate signature part for principal \"" + currentCertificate.getSubjectX500Principal().getName() + "\" : " + this.hocr.getFileName());
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                    LOG.error((Object)("Could not validate signature part for principal \"" + currentCertificate.getSubjectX500Principal().getName() + "\" : " + this.hocr.getFileName()), (Throwable)e);
                    throw new FormatNotUnderstoodException("Could not validate signature part for principal \"" + currentCertificate.getSubjectX500Principal().getName() + "\" : " + this.hocr.getFileName());
                }
            }
            LOG.info((Object)("Successfully verifed all signatures of OXXML (.xlsx) file: " + this.hocr.getFileName()));
        }
        this.formulaEvaluator = this.currentWorkbook.getCreationHelper().createFormulaEvaluator();
        this.addedFormulaEvaluators.put(this.hocr.getFileName(), this.formulaEvaluator);
        this.formulaEvaluator.setIgnoreMissingWorkbooks(this.hocr.getIgnoreMissingLinkedWorkbooks());
        this.filtered = this.checkFiltered();
        this.currentRow = 0;
        if (this.sheets == null) {
            this.currentSheetName = this.currentWorkbook.getSheetAt(0).getSheetName();
        } else {
            if (this.sheets.length < 1) {
                throw new FormatNotUnderstoodException("Error: no sheets selected");
            }
            this.currentSheetName = this.sheets[0];
        }
        this.currentRow += this.hocr.getSkipLines();
        if (this.hocr.getReadHeader()) {
            LOG.debug((Object)"Reading header...");
            Object[] firstRow = this.getNext();
            if (firstRow != null) {
                this.header = new String[firstRow.length];
                for (int i = 0; i < firstRow.length; ++i) {
                    if (firstRow[i] == null || "".equals(((SpreadSheetCellDAO)firstRow[i]).getFormattedValue())) continue;
                    this.header[i] = ((SpreadSheetCellDAO)firstRow[i]).getFormattedValue();
                }
                this.header = MSExcelParser.sanitizeHeaders(this.header, this.hocr.getColumnNameRegex(), this.hocr.getColumnNameReplace());
            } else {
                this.header = new String[0];
            }
        }
    }

    @Override
    public boolean addLinkedWorkbook(String name, InputStream inputStream, String password) throws FormatNotUnderstoodException {
        if (this.addedFormulaEvaluators.containsKey(name)) {
            return false;
        }
        LOG.debug((Object)("Start adding  \"" + name + "\" to current workbook"));
        HadoopOfficeReadConfiguration linkedWBHOCR = new HadoopOfficeReadConfiguration();
        linkedWBHOCR.setLocale(this.hocr.getLocale());
        linkedWBHOCR.setSheets(null);
        linkedWBHOCR.setIgnoreMissingLinkedWorkbooks(this.hocr.getIgnoreMissingLinkedWorkbooks());
        linkedWBHOCR.setFileName(name);
        linkedWBHOCR.setPassword(password);
        linkedWBHOCR.setMetaDataFilter(null);
        MSExcelParser linkedWBMSExcelParser = new MSExcelParser(linkedWBHOCR, null);
        linkedWBMSExcelParser.parse(inputStream);
        this.addedWorkbooks.add(linkedWBMSExcelParser.getCurrentWorkbook());
        this.addedFormulaEvaluators.put(name, linkedWBMSExcelParser.getCurrentFormulaEvaluator());
        this.formulaEvaluator.setupReferencedWorkbooks(this.addedFormulaEvaluators);
        return true;
    }

    @Override
    public List<String> getLinkedWorkbooks() {
        ArrayList<String> result = new ArrayList();
        if (this.currentWorkbook instanceof HSSFWorkbook) {
            result = this.getLinkedWorkbooksHSSF();
        } else if (this.currentWorkbook instanceof XSSFWorkbook) {
            for (ExternalLinksTable element : ((XSSFWorkbook)this.currentWorkbook).getExternalLinksTable()) {
                result.add(element.getLinkedFileName());
            }
        } else {
            LOG.warn((Object)"Cannot determine linked workbooks");
        }
        return result;
    }

    private List<String> getLinkedWorkbooksHSSF() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            InternalWorkbook intWb = ((HSSFWorkbook)this.currentWorkbook).getInternalWorkbook();
            Method linkTableMethod = InternalWorkbook.class.getDeclaredMethod("getOrCreateLinkTable", new Class[0]);
            linkTableMethod.setAccessible(true);
            Object linkTable = linkTableMethod.invoke((Object)intWb, new Object[0]);
            Method externalBooksMethod = linkTable.getClass().getDeclaredMethod("getExternalBookAndSheetName", Integer.TYPE);
            externalBooksMethod.setAccessible(true);
            int i = 0;
            try {
                while (i < 100) {
                    String[] externalBooks;
                    if ((externalBooks = (String[])externalBooksMethod.invoke(linkTable, i++)) == null || externalBooks.length <= 0) continue;
                    result.add(externalBooks[0]);
                }
            }
            catch (InvocationTargetException e) {
                if (!(e.getCause() instanceof IndexOutOfBoundsException)) {
                    throw e;
                }
            }
        }
        catch (NoSuchMethodException nsme) {
            LOG.error((Object)COULD_NOT_RETRIEVE_LINKED_WORKBOOKS_FOR_OLD_EXCEL_FORMAT);
            LOG.error((Object)nsme);
        }
        catch (IllegalAccessException iae) {
            LOG.error((Object)COULD_NOT_RETRIEVE_LINKED_WORKBOOKS_FOR_OLD_EXCEL_FORMAT);
            LOG.error((Object)iae);
        }
        catch (InvocationTargetException ite) {
            LOG.error((Object)COULD_NOT_RETRIEVE_LINKED_WORKBOOKS_FOR_OLD_EXCEL_FORMAT);
            LOG.error((Object)ite);
        }
        return result;
    }

    @Override
    public boolean getFiltered() {
        return this.filtered;
    }

    public FormulaEvaluator getCurrentFormulaEvaluator() {
        return this.formulaEvaluator;
    }

    public Workbook getCurrentWorkbook() {
        return this.currentWorkbook;
    }

    @Override
    public long getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public String getCurrentSheetName() {
        return this.currentSheetName;
    }

    @Override
    public Object[] getNext() {
        Object[] result = null;
        if (this.sheets == null ? !this.nextAllSheets() : !this.nextSpecificSheets()) {
            return result;
        }
        Sheet rSheet = this.currentWorkbook.getSheetAt(this.currentSheet);
        Row rRow = rSheet.getRow(this.currentRow);
        if (rRow == null || rRow.getLastCellNum() < 0) {
            ++this.currentRow;
            return new SpreadSheetCellDAO[0];
        }
        result = new SpreadSheetCellDAO[rRow.getLastCellNum()];
        for (int i = 0; i < rRow.getLastCellNum(); ++i) {
            Cell currentCell = rRow.getCell(i);
            if (currentCell == null) {
                result[i] = null;
                continue;
            }
            String formattedValue = this.useDataFormatter.formatCellValue(currentCell, this.formulaEvaluator);
            String formula = "";
            if (currentCell.getCellType() == CellType.FORMULA) {
                formula = currentCell.getCellFormula();
            }
            Comment currentCellComment = currentCell.getCellComment();
            String comment = "";
            if (currentCellComment != null) {
                comment = currentCellComment.getString().getString();
            }
            String address = currentCell.getAddress().toString();
            String sheetName = currentCell.getSheet().getSheetName();
            SpreadSheetCellDAO mySpreadSheetCellDAO = new SpreadSheetCellDAO(formattedValue, comment, formula, address, sheetName);
            result[i] = mySpreadSheetCellDAO;
        }
        ++this.currentRow;
        return result;
    }

    private boolean nextAllSheets() {
        if (this.currentWorkbook == null) {
            return false;
        }
        while (this.currentWorkbook.getSheetAt(this.currentSheet) != null && this.currentRow > this.currentWorkbook.getSheetAt(this.currentSheet).getLastRowNum()) {
            ++this.currentSheet;
            this.currentRow = 0;
            if (this.hocr.getSkipLinesAllSheets()) {
                this.currentRow += this.hocr.getSkipLines();
            }
            if (this.hocr.getIgnoreHeaderInAllSheets()) {
                ++this.currentRow;
            }
            if (this.currentSheet >= this.currentWorkbook.getNumberOfSheets()) {
                return false;
            }
            this.currentSheetName = this.currentWorkbook.getSheetAt(this.currentSheet).getSheetName();
        }
        return true;
    }

    private boolean nextSpecificSheets() {
        if (this.currentWorkbook == null) {
            return false;
        }
        block0: while (this.sheetsIndex != this.sheets.length) {
            if (this.currentWorkbook.getSheet(this.sheets[this.sheetsIndex]) == null) {
                LOG.warn((Object)("Sheet \"" + this.sheets[this.sheetsIndex] + "\" not found"));
            } else if (this.currentRow <= this.currentWorkbook.getSheet(this.sheets[this.sheetsIndex]).getLastRowNum()) {
                this.currentSheet = this.currentWorkbook.getSheetIndex(this.currentWorkbook.getSheet(this.sheets[this.sheetsIndex]));
                this.currentSheetName = this.currentWorkbook.getSheetAt(this.currentSheet).getSheetName();
                break;
            }
            while (this.currentWorkbook != null && this.currentWorkbook.getSheetAt(this.currentSheet) != null && this.currentRow > this.currentWorkbook.getSheet(this.sheets[this.sheetsIndex]).getLastRowNum()) {
                ++this.sheetsIndex;
                if (this.sheetsIndex == this.sheets.length) {
                    LOG.info((Object)"No further sheets found");
                    continue block0;
                }
                this.currentRow = 0;
                if (this.hocr.getSkipLinesAllSheets()) {
                    this.currentRow += this.hocr.getSkipLines();
                }
                if (!this.hocr.getIgnoreHeaderInAllSheets()) continue;
                ++this.currentRow;
            }
        }
        return this.sheetsIndex < this.sheets.length;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.currentWorkbook != null) {
            LOG.debug((Object)("Closing current Workbook \"" + this.hocr.getFileName() + "\""));
            this.currentWorkbook.close();
        }
        for (Workbook addedWorkbook : this.addedWorkbooks) {
            addedWorkbook.close();
        }
    }

    private boolean checkFiltered() {
        if (this.hocr.getMetaDataFilter() == null || this.hocr.getMetaDataFilter().size() == 0) {
            return true;
        }
        if (this.currentWorkbook instanceof XSSFWorkbook) {
            return this.checkFilteredXSSF();
        }
        if (this.currentWorkbook instanceof HSSFWorkbook) {
            return this.checkFilteredHSSF();
        }
        LOG.error((Object)"Unknown workbook format. Cannot check if document matches metadata filter");
        return false;
    }

    private boolean checkFilteredXSSF() {
        Object corePropStr;
        XSSFWorkbook currentXSSFWorkbook = (XSSFWorkbook)this.currentWorkbook;
        POIXMLProperties props = currentXSSFWorkbook.getProperties();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        boolean matchAll = true;
        boolean matchFull = true;
        boolean matchOnce = false;
        if (this.hocr.getMetaDataFilter().get(MATCH_ALL) != null) {
            if ("true".equalsIgnoreCase(this.hocr.getMetaDataFilter().get(MATCH_ALL))) {
                matchAll = true;
                LOG.info((Object)"matching all metadata properties");
            } else if ("false".equalsIgnoreCase(this.hocr.getMetaDataFilter().get(MATCH_ALL))) {
                matchAll = false;
                LOG.info((Object)"matching at least one metadata property");
            } else {
                LOG.error((Object)"Metadata property matchAll not defined correctly. Assuming that at only least one attribute needs to match");
            }
        }
        POIXMLProperties.CoreProperties coreProp = props.getCoreProperties();
        String corePropertyName = "category";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getCategory();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "contentstatus";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getContentStatus();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "contenttype";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getContentType();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "created";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getCreated();
            if (corePropStr != null && format.format((Date)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + format.format((Date)corePropStr) + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
                LOG.debug((Object)corePropertyName);
            }
        }
        corePropertyName = "creator";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getCreator();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "description";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getDescription();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "identifier";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getIdentifier();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "keywords";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getKeywords();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "lastmodifiedbyuser";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getLastModifiedByUser();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "lastprinted";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getLastPrinted();
            if (corePropStr != null && format.format((Date)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + format.format((Date)corePropStr) + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
                LOG.debug((Object)corePropertyName);
            }
        }
        corePropertyName = "modified";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getModified();
            if (corePropStr != null && format.format((Date)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
                LOG.debug((Object)corePropertyName);
            }
        }
        corePropertyName = "revision";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getRevision();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "subject";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getSubject();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        corePropertyName = "title";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            corePropStr = coreProp.getTitle();
            if (corePropStr != null && ((String)corePropStr).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
                LOG.debug((Object)(NOT_MATCHING + (String)corePropStr + ":" + this.hocr.getMetaDataFilter().get(corePropertyName)));
            }
        }
        POIXMLProperties.CustomProperties custProp = props.getCustomProperties();
        for (Map.Entry<String, String> entry : this.hocr.getMetaDataFilter().entrySet()) {
            String valueMatch;
            String strippedKey;
            if (!entry.getKey().startsWith("custom.") || (strippedKey = entry.getKey().substring("custom.".length())).length() <= 0 || (valueMatch = entry.getValue()) == null) continue;
            if (custProp.getProperty(strippedKey) != null && custProp.getProperty(strippedKey).getName() != null && custProp.getProperty(strippedKey).getLpwstr().matches(valueMatch)) {
                matchOnce = true;
                continue;
            }
            matchFull = false;
        }
        if (!matchAll) {
            return matchOnce;
        }
        return matchFull;
    }

    private boolean checkFilteredHSSF() {
        String coreProp;
        HSSFWorkbook currentHSSFWorkbook = (HSSFWorkbook)this.currentWorkbook;
        SummaryInformation summaryInfo = currentHSSFWorkbook.getSummaryInformation();
        boolean matchAll = true;
        boolean matchFull = true;
        boolean matchOnce = false;
        if (this.hocr.getMetaDataFilter().get(MATCH_ALL) != null) {
            if ("true".equalsIgnoreCase(this.hocr.getMetaDataFilter().get(MATCH_ALL))) {
                matchAll = true;
            } else if ("false".equalsIgnoreCase(this.hocr.getMetaDataFilter().get(MATCH_ALL))) {
                matchAll = false;
            } else {
                LOG.error((Object)"Metadata property matchAll not defined correctly. Assuming that at only least one attribute needs to match");
            }
        }
        String corePropertyName = "applicationname";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            coreProp = summaryInfo.getApplicationName();
            if (coreProp != null && coreProp.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "author";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            coreProp = summaryInfo.getAuthor();
            if (coreProp != null && coreProp.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "charcount";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            int coreProp2 = summaryInfo.getCharCount();
            if (String.valueOf(coreProp2).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "comments";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            String coreProp3 = summaryInfo.getComments();
            if (coreProp3 != null && coreProp3.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "createddatetime";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            Date coreProp4 = summaryInfo.getCreateDateTime();
            if (coreProp4 != null && coreProp4.toString().matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "edittime";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            long coreProp5 = summaryInfo.getEditTime();
            if (String.valueOf(coreProp5).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "keywords";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            String coreProp6 = summaryInfo.getKeywords();
            if (coreProp6 != null && coreProp6.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "lastauthor";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            String coreProp7 = summaryInfo.getLastAuthor();
            if (coreProp7 != null && coreProp7.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "lastprinted";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            Date coreProp8 = summaryInfo.getLastPrinted();
            if (coreProp8 != null && coreProp8.toString().matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "lastsavedatetime";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            Date coreProp9 = summaryInfo.getLastSaveDateTime();
            if (coreProp9 != null && coreProp9.toString().matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "pagecount";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            int coreProp10 = summaryInfo.getPageCount();
            if (String.valueOf(coreProp10).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "revnumber";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            String coreProp11 = summaryInfo.getRevNumber();
            if (coreProp11 != null && coreProp11.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "security";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            int coreProp12 = summaryInfo.getSecurity();
            if (String.valueOf(coreProp12).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "subject";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            String coreProp13 = summaryInfo.getSubject();
            if (coreProp13 != null && coreProp13.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "template";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            String coreProp14 = summaryInfo.getTemplate();
            if (coreProp14 != null && coreProp14.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "title";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            String coreProp15 = summaryInfo.getTitle();
            if (coreProp15 != null && coreProp15.matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        corePropertyName = "wordcount";
        if (this.hocr.getMetaDataFilter().get(corePropertyName) != null) {
            int coreProp16 = summaryInfo.getWordCount();
            if (String.valueOf(coreProp16).matches(this.hocr.getMetaDataFilter().get(corePropertyName))) {
                matchOnce = true;
            } else {
                matchFull = false;
            }
        }
        if (!matchAll) {
            return matchOnce;
        }
        return matchFull;
    }

    @Override
    public void setCurrentRow(long row) {
        this.currentRow = (int)row;
    }

    @Override
    public void setCurrentSheet(long sheet) {
        this.currentSheet = (int)sheet;
    }

    @Override
    public long getCurrentSheet() {
        return this.currentSheet;
    }

    @Override
    public String[] getHeader() {
        return this.header;
    }

    public static String[] sanitizeHeaders(String[] headers, String regex, String replace) {
        String[] result = new String[headers.length];
        HashMap<String, Integer> headerHashMap = new HashMap<String, Integer>();
        for (int i = 0; i < headers.length; ++i) {
            Integer existingEntry;
            String currentColumn = headers[i];
            if (currentColumn == null || "".equals(currentColumn)) {
                currentColumn = "Col" + i;
            }
            if (regex != null && !"".equals(regex)) {
                currentColumn = currentColumn.replaceAll(regex, replace);
            }
            if ((existingEntry = (Integer)headerHashMap.get(currentColumn)) == null) {
                existingEntry = 1;
            } else {
                existingEntry = existingEntry + 1;
                currentColumn = currentColumn + existingEntry;
            }
            result[i] = currentColumn;
            headerHashMap.put(currentColumn, existingEntry);
        }
        return result;
    }
}

