/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.parser.msexcel.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.StaxHelper;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.internal.cache.LRUCache;

public class EncryptedCachedDiskStringsTable
extends SharedStringsTable
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog((String)EncryptedCachedDiskStringsTable.class.getName());
    public static final int compressBufferSize = 0x100000;
    public static final String encoding = "UTF-8";
    private List<Long> stringPositionInFileList;
    private Map<Integer, String> cache;
    private int cacheSize;
    private File tempFile;
    private long tempFileSize;
    private InputStream in;
    private InputStream originalIS;
    private CipherAlgorithm ca;
    private ChainingMode cm;
    private Cipher ciEncrypt;
    private Cipher ciDecrypt;
    private boolean compressTempFile;
    private long currentPos;
    private int currentItem;
    private int count;
    private RandomAccessFile tempRAF = null;

    public EncryptedCachedDiskStringsTable(PackagePart part, int cacheSize, boolean compressTempFile, CipherAlgorithm ca, ChainingMode cm) throws IOException {
        this.cacheSize = cacheSize;
        this.count = 0;
        if (this.cacheSize > 0) {
            this.cache = new LRUCache<Integer, String>((int)Math.ceil((double)this.cacheSize / 0.75) + 1);
            this.stringPositionInFileList = new ArrayList<Long>(this.cacheSize);
        } else {
            this.cache = new LRUCache<Integer, String>();
            this.stringPositionInFileList = new ArrayList<Long>();
        }
        this.stringPositionInFileList = new ArrayList<Long>();
        this.compressTempFile = compressTempFile;
        this.tempFile = TempFile.createTempFile("hadooffice-poi-temp-sst", ".tmp");
        this.tempFileSize = 0L;
        if (ca != null) {
            SecureRandom sr = new SecureRandom();
            byte[] iv = new byte[ca.blockSize];
            byte[] key = new byte[ca.defaultKeySize / 8];
            sr.nextBytes(iv);
            sr.nextBytes(key);
            SecretKeySpec skeySpec = new SecretKeySpec(key, ca.jceId);
            this.ca = ca;
            this.cm = cm;
            if (this.cm.jceId.equals(ChainingMode.ecb.jceId)) {
                this.cm = ChainingMode.cbc;
            }
            this.ciEncrypt = CryptoFunctions.getCipher(skeySpec, this.ca, this.cm, iv, 1, "PKCS5Padding");
            this.ciDecrypt = CryptoFunctions.getCipher(skeySpec, this.ca, this.cm, iv, 2, "PKCS5Padding");
        }
        this.originalIS = part.getInputStream();
        this.readFrom(this.originalIS);
    }

    @Override
    public void readFrom(InputStream is) throws IOException {
        this.currentItem = 0;
        OutputStream tempOS = null;
        if (this.ca != null || this.compressTempFile) {
            tempOS = new FileOutputStream(this.tempFile);
            if (this.ca != null) {
                tempOS = new CipherOutputStream(tempOS, this.ciEncrypt);
            }
            if (this.compressTempFile) {
                tempOS = new GZIPOutputStream(tempOS, 0x100000);
            }
        } else {
            this.tempRAF = new RandomAccessFile(this.tempFile, "rw");
        }
        XMLEventReader xer = null;
        try {
            xer = StaxHelper.newXMLInputFactory().createXMLEventReader(this.originalIS);
            while (xer.hasNext()) {
                XMLEvent xe = xer.nextEvent();
                if (!xe.isStartElement() || !xe.asStartElement().getName().getLocalPart().equalsIgnoreCase("si")) continue;
                String siText = this.parseSIText(xer);
                this.addString(siText, tempOS);
                ++this.count;
            }
        }
        catch (XMLStreamException e) {
            LOG.error((Object)("Cannot read original SharedStringTable from document. Exception " + e));
            throw new IOException(e);
        }
        catch (FormatNotUnderstoodException e) {
            LOG.error((Object)("Cannot read properly SharedStringTable from document. Exception " + e));
            throw new IOException(e);
        }
        finally {
            if (tempOS != null) {
                tempOS.close();
            }
        }
        this.accessTempFile(0L);
    }

    @Override
    public RichTextString getItemAt(int idx) {
        try {
            return new XSSFRichTextString(this.getString(idx));
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot read from temporary shared String table. Exception: " + e));
            return new XSSFRichTextString("");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (!this.tempFile.delete()) {
            LOG.warn((Object)("Cannot delete tempFile: " + this.tempFile.getAbsolutePath()));
            throw new IOException("Cannot delete tempFile: " + this.tempFile.getAbsolutePath());
        }
    }

    private void addString(String str, OutputStream os) throws IOException {
        if (this.cacheSize >= 0) {
            byte[] strbytes = str.getBytes(encoding);
            byte[] sizeOfStr = ByteBuffer.allocate(4).putInt(strbytes.length).array();
            this.stringPositionInFileList.add(this.tempFileSize);
            if (os != null) {
                os.write(sizeOfStr);
                os.write(strbytes);
            } else {
                FileChannel fc = this.tempRAF.getChannel().position(this.tempFileSize);
                fc.write(ByteBuffer.wrap(sizeOfStr));
                fc.write(ByteBuffer.wrap(strbytes));
            }
            this.tempFileSize += (long)(sizeOfStr.length + strbytes.length);
        }
        if (this.cacheSize < 0) {
            this.cache.put(this.currentItem, str);
            ++this.currentItem;
        } else if (this.cacheSize > 0 && this.currentItem < this.cacheSize) {
            this.cache.put(this.currentItem, str);
            ++this.currentItem;
        }
    }

    private String parseSIText(XMLEventReader xer) throws XMLStreamException, FormatNotUnderstoodException {
        XMLEvent xe;
        String result = "";
        block11: while ((xe = xer.nextTag()).isStartElement()) {
            String elementName;
            switch (elementName = xe.asStartElement().getName().getLocalPart().toUpperCase()) {
                case "T": {
                    result = xer.getElementText();
                    continue block11;
                }
                case "R": {
                    result = this.parseSIRichText(xer);
                    continue block11;
                }
                case "RPH": 
                case "PHONETICPR": {
                    this.skipXMLElementHierarchy(xer);
                    continue block11;
                }
            }
            LOG.error((Object)("Unknown string item in shared string table: " + elementName));
            throw new FormatNotUnderstoodException("Unknown string item in shared string table: " + elementName);
        }
        return result;
    }

    private String parseSIRichText(XMLEventReader xer) throws XMLStreamException, FormatNotUnderstoodException {
        XMLEvent xe;
        String result = "";
        block7: while ((xe = xer.nextTag()).isStartElement()) {
            String elementName;
            switch (elementName = xe.asStartElement().getName().getLocalPart().toUpperCase()) {
                case "T": {
                    result = xer.getElementText();
                    continue block7;
                }
            }
            LOG.error((Object)("Unknown rich text string item in shared string table: " + elementName));
            throw new FormatNotUnderstoodException("Unknown rich text string item in shared string table: " + elementName);
        }
        return result;
    }

    private String getString(int index) throws IOException {
        if (this.cache.containsKey(index)) {
            return this.cache.get(index);
        }
        long itemPosition = this.stringPositionInFileList.get(index);
        String result = null;
        if (this.tempRAF == null) {
            this.accessTempFile(itemPosition);
            byte[] readSize = new byte[4];
            this.in.read(readSize);
            int sizeOfString = ByteBuffer.wrap(readSize).getInt();
            byte[] strbytes = new byte[sizeOfString];
            this.in.read(strbytes);
            this.currentPos += (long)(readSize.length + strbytes.length);
            result = new String(strbytes, encoding);
        } else {
            FileChannel fc = this.tempRAF.getChannel().position(itemPosition);
            ByteBuffer bb = ByteBuffer.allocate(4);
            fc.read(bb);
            bb.flip();
            int sizeOfStr = bb.getInt();
            bb = ByteBuffer.allocate(sizeOfStr);
            fc.read(bb);
            bb.flip();
            result = new String(bb.array(), encoding);
        }
        if (this.cacheSize != 0) {
            this.cache.put(index, result);
        }
        return result;
    }

    private void skipXMLElementHierarchy(XMLEventReader xer) throws XMLStreamException {
        while (xer.nextTag().isStartElement()) {
            this.skipXMLElementHierarchy(xer);
        }
    }

    private void accessTempFile(long position) throws IOException {
        if (position == 0L || position < this.currentPos) {
            this.in = new FileInputStream(this.tempFile);
            if (this.ca != null) {
                this.in = new CipherInputStream(this.in, this.ciDecrypt);
            }
            this.in = this.compressTempFile ? new GZIPInputStream(this.in, 0x100000) : new BufferedInputStream(this.in, 0x100000);
            this.currentPos = 0L;
        } else if (position > this.currentPos) {
            this.in.skip(position - this.currentPos);
            this.currentPos = position;
        }
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

