/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.parser.msexcel.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingRowDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.util.msexcel.MSExcelUtil;

public class HSSFEventParser
implements HSSFListener {
    private static final Log LOG = LogFactory.getLog((String)HSSFEventParser.class.getName());
    private Map<Integer, List<SpreadSheetCellDAO[]>> spreadSheetCellDAOCache;
    private List<String> sheetList;
    private Map<Integer, Boolean> sheetMap;
    private Map<Integer, Long> sheetSizeMap;
    private List<Integer> extendedRecordFormatIndexList;
    private Map<Integer, String> formatRecordIndexMap;
    private DataFormatter useDataFormatter;
    private int currentSheet;
    private String[] sheets;
    private long currentCellNum;
    private int cachedRowNum;
    private short cachedColumnNum;
    private SSTRecord currentSSTrecord;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;

    public HSSFEventParser(List<String> sheetNameList, DataFormatter useDataFormatter, Map<Integer, List<SpreadSheetCellDAO[]>> spreadSheetCellDAOCache, String[] sheets) {
        this.spreadSheetCellDAOCache = spreadSheetCellDAOCache;
        this.sheets = sheets;
        this.currentCellNum = 0L;
        this.cachedRowNum = 0;
        this.cachedColumnNum = 0;
        this.sheetList = new ArrayList<String>();
        this.sheetMap = new HashMap<Integer, Boolean>();
        this.sheetSizeMap = new HashMap<Integer, Long>();
        this.currentSheet = 0;
        this.extendedRecordFormatIndexList = new ArrayList<Integer>();
        this.formatRecordIndexMap = new HashMap<Integer, String>();
        this.sheetList = sheetNameList;
        this.useDataFormatter = useDataFormatter;
    }

    public void setSheetRecordCollectingListener(EventWorkbookBuilder.SheetRecordCollectingListener listener) {
        this.workbookBuildingListener = listener;
    }

    @Override
    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() == 5) {
                    if (this.stubWorkbook == null && this.workbookBuildingListener != null) {
                        this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                        break;
                    }
                    LOG.error((Object)"Cannot create stub network. Formula Strings cannot be parsed");
                    break;
                }
                if (bof.getType() != 16) break;
                break;
            }
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                String currentSheet = bsr.getSheetname();
                LOG.debug((Object)("Sheet found: " + currentSheet));
                if (this.sheets == null) {
                    this.sheetMap.put(this.sheetList.size(), true);
                    this.sheetSizeMap.put(this.sheetList.size(), 0L);
                    this.sheetList.add(currentSheet);
                } else if (currentSheet != null) {
                    boolean found = false;
                    for (int i = 0; i < this.sheets.length; ++i) {
                        if (!currentSheet.equals(this.sheets[i])) continue;
                        found = true;
                        break;
                    }
                    this.sheetMap.put(this.sheetList.size(), found);
                    this.sheetList.add(currentSheet);
                }
                if (!this.sheetMap.get(this.sheetList.size() - 1).booleanValue()) break;
                this.spreadSheetCellDAOCache.put(this.sheetList.size() - 1, new ArrayList());
                break;
            }
            case 520: {
                RowRecord rowRec = (RowRecord)record;
                LOG.debug((Object)("Row found. Number of Cells: " + rowRec.getLastCol()));
                if (this.currentSheet == 0 && rowRec.getRowNumber() == 0) {
                    ++this.currentSheet;
                    this.currentCellNum = 0L;
                } else if (this.currentSheet > 0 && rowRec.getRowNumber() == 0) {
                    LOG.debug((Object)("Sheet number : " + this.currentSheet + " total number of cells " + this.currentCellNum));
                    this.sheetSizeMap.put(this.currentSheet - 1, this.currentCellNum);
                    ++this.currentSheet;
                    this.currentCellNum = 0L;
                }
                if (this.sheetMap.get(this.currentSheet - 1).booleanValue()) {
                    this.spreadSheetCellDAOCache.get(this.currentSheet - 1).add(new SpreadSheetCellDAO[rowRec.getLastCol()]);
                }
                this.currentCellNum += (long)rowRec.getLastCol();
                break;
            }
            case 6: {
                LOG.debug((Object)"Formula Record found");
                FormulaRecord formRec = (FormulaRecord)record;
                if (!this.sheetMap.get(this.currentSheet - 1).booleanValue()) break;
                String formulaString = "";
                if (this.stubWorkbook != null) {
                    formulaString = HSSFFormulaParser.toFormulaString(this.stubWorkbook, formRec.getParsedExpression());
                }
                if (formRec.hasCachedResultString()) {
                    this.cachedColumnNum = formRec.getColumn();
                    this.cachedRowNum = formRec.getRow();
                    break;
                }
                if (formRec.getColumn() >= this.spreadSheetCellDAOCache.get(this.currentSheet - 1).get(formRec.getRow()).length) {
                    LOG.error((Object)("More cells in row than expected. Row number:" + formRec.getRow() + "Column number: " + formRec.getColumn() + "row length " + this.spreadSheetCellDAOCache.get(this.currentSheet - 1).get(formRec.getRow()).length));
                    break;
                }
                int formatIndex = this.extendedRecordFormatIndexList.get(formRec.getXFIndex());
                String theNumber = this.useDataFormatter.formatRawCellContents(formRec.getValue(), formatIndex, this.formatRecordIndexMap.get(formatIndex));
                this.spreadSheetCellDAOCache.get((Object)Integer.valueOf((int)(this.currentSheet - 1))).get((int)formRec.getRow())[formRec.getColumn()] = new SpreadSheetCellDAO(theNumber, "", formulaString, MSExcelUtil.getCellAddressA1Format(formRec.getRow(), formRec.getColumn()), this.sheetList.get(this.currentSheet - 1));
                break;
            }
            case 519: {
                LOG.debug((Object)"String Record found");
                StringRecord strRec = (StringRecord)record;
                if (!this.sheetMap.get(this.currentSheet - 1).booleanValue()) break;
                this.spreadSheetCellDAOCache.get((Object)Integer.valueOf((int)(this.currentSheet - 1))).get((int)this.cachedRowNum)[this.cachedColumnNum] = new SpreadSheetCellDAO(strRec.getString(), "", "", MSExcelUtil.getCellAddressA1Format(this.cachedRowNum, this.cachedColumnNum), this.sheetList.get(this.currentSheet - 1));
                break;
            }
            case 515: {
                SpreadSheetCellDAO mySpreadSheetCellDAO;
                LOG.debug((Object)"Number Record found");
                NumberRecord numrec = (NumberRecord)record;
                if (!this.sheetMap.get(this.currentSheet - 1).booleanValue()) break;
                if (numrec.getColumn() >= this.spreadSheetCellDAOCache.get(this.currentSheet - 1).get(numrec.getRow()).length) {
                    LOG.error((Object)("More cells in row than expected. Row number:" + numrec.getRow() + "Column number: " + numrec.getColumn() + "row length " + this.spreadSheetCellDAOCache.get(this.currentSheet - 1).get(numrec.getRow()).length));
                    break;
                }
                int formatIndex = this.extendedRecordFormatIndexList.get(numrec.getXFIndex());
                String theNumber = this.useDataFormatter.formatRawCellContents(numrec.getValue(), formatIndex, this.formatRecordIndexMap.get(formatIndex));
                this.spreadSheetCellDAOCache.get((Object)Integer.valueOf((int)(this.currentSheet - 1))).get((int)numrec.getRow())[numrec.getColumn()] = mySpreadSheetCellDAO = new SpreadSheetCellDAO(theNumber, "", "", MSExcelUtil.getCellAddressA1Format(numrec.getRow(), numrec.getColumn()), this.sheetList.get(this.currentSheet - 1));
                break;
            }
            case 252: {
                LOG.debug((Object)"SST record found");
                this.currentSSTrecord = (SSTRecord)record;
                break;
            }
            case 253: {
                LOG.debug((Object)"Label found");
                LabelSSTRecord lrec = (LabelSSTRecord)record;
                if (!this.sheetMap.get(this.currentSheet - 1).booleanValue()) break;
                if (lrec.getColumn() >= this.spreadSheetCellDAOCache.get(this.currentSheet - 1).get(lrec.getRow()).length) {
                    LOG.error((Object)("More cells in row than expected. Row number:" + lrec.getRow() + "Column number: " + lrec.getColumn() + "row length " + this.spreadSheetCellDAOCache.get(this.currentSheet - 1).get(lrec.getRow()).length));
                    break;
                }
                if (lrec.getSSTIndex() < 0 || lrec.getSSTIndex() >= this.currentSSTrecord.getNumUniqueStrings()) {
                    LOG.error((Object)"Invalid SST record index. Cell ignored");
                    break;
                }
                this.spreadSheetCellDAOCache.get((Object)Integer.valueOf((int)(this.currentSheet - 1))).get((int)lrec.getRow())[lrec.getColumn()] = new SpreadSheetCellDAO(this.currentSSTrecord.getString(lrec.getSSTIndex()).getString(), "", "", MSExcelUtil.getCellAddressA1Format(lrec.getRow(), lrec.getColumn()), this.sheetList.get(this.currentSheet - 1));
                break;
            }
            case 224: {
                LOG.debug((Object)"Found extended format record");
                ExtendedFormatRecord nfir = (ExtendedFormatRecord)record;
                this.extendedRecordFormatIndexList.add(Integer.valueOf(nfir.getFormatIndex()));
                break;
            }
            case 1054: {
                LOG.debug((Object)"Found format record");
                FormatRecord frec = (FormatRecord)record;
                this.formatRecordIndexMap.put(frec.getIndexCode(), frec.getFormatString());
                break;
            }
        }
        if (record instanceof MissingRowDummyRecord) {
            MissingRowDummyRecord emptyRow = (MissingRowDummyRecord)record;
            LOG.debug((Object)"Detected Empty row");
            if (this.currentSheet == 0 && emptyRow.getRowNumber() == 0) {
                ++this.currentSheet;
                this.currentCellNum = 0L;
            } else if (this.currentSheet > 0 && emptyRow.getRowNumber() == 0) {
                LOG.debug((Object)("Sheet number : " + this.currentSheet + " total number of cells " + this.currentCellNum));
                this.sheetSizeMap.put(this.currentSheet - 1, this.currentCellNum);
                ++this.currentSheet;
                this.currentCellNum = 0L;
            }
            if (this.sheetMap.get(this.currentSheet - 1).booleanValue()) {
                this.spreadSheetCellDAOCache.get(this.currentSheet - 1).add(new SpreadSheetCellDAO[0]);
            }
        }
    }
}

