/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.parser.msexcel.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;

public class XSSFEventParser
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private Map<Integer, List<SpreadSheetCellDAO[]>> spreadSheetCellDAOCache;
    private ArrayList<SpreadSheetCellDAO> spreadSheetCellDAOCurrentRow;
    private String sheetName;
    private Integer currentSheet;
    private int currentRow;
    private int currentColumn;

    public XSSFEventParser(Integer currentSheet, String sheetName, Map<Integer, List<SpreadSheetCellDAO[]>> spreadSheetCellDAOCache) {
        this.currentSheet = currentSheet;
        this.spreadSheetCellDAOCache = spreadSheetCellDAOCache;
        this.spreadSheetCellDAOCache.put(currentSheet, new ArrayList());
        this.sheetName = sheetName;
        this.currentRow = -1;
    }

    @Override
    public void startRow(int rowNum) {
        if (rowNum > this.currentRow + 1) {
            while (rowNum - 1 != this.currentRow) {
                this.spreadSheetCellDAOCache.get(this.currentSheet).add(new SpreadSheetCellDAO[0]);
                ++this.currentRow;
            }
        }
        this.spreadSheetCellDAOCurrentRow = new ArrayList();
        this.currentColumn = 0;
    }

    @Override
    public void endRow(int rowNum) {
        ++this.currentRow;
        SpreadSheetCellDAO[] currentRowDAO = new SpreadSheetCellDAO[this.spreadSheetCellDAOCurrentRow.size()];
        currentRowDAO = this.spreadSheetCellDAOCurrentRow.toArray(currentRowDAO);
        this.spreadSheetCellDAOCache.get(this.currentSheet).add(currentRowDAO);
    }

    @Override
    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        CellAddress currentCellAddress = new CellAddress(cellReference);
        for (int i = this.currentColumn; i < currentCellAddress.getColumn(); ++i) {
            this.spreadSheetCellDAOCurrentRow.add(null);
            ++this.currentColumn;
        }
        SpreadSheetCellDAO currentDAO = null;
        currentDAO = comment != null ? new SpreadSheetCellDAO(formattedValue, comment.getString().getString(), "", cellReference, this.sheetName) : new SpreadSheetCellDAO(formattedValue, "", "", cellReference, this.sheetName);
        ++this.currentColumn;
        this.spreadSheetCellDAOCurrentRow.add(currentDAO);
    }

    @Override
    public void headerFooter(String text, boolean isHeader, String tagName) {
    }
}

