/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapreduce;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.zuinnote.hadoop.office.format.common.HadoopUtil;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.writer.InvalidCellSpecificationException;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;
import org.zuinnote.hadoop.office.format.mapreduce.AbstractSpreadSheetDocumentFileOutputFormat;
import org.zuinnote.hadoop.office.format.mapreduce.ExcelFileOutputFormat;
import org.zuinnote.hadoop.office.format.mapreduce.ExcelRowRecordWriter;

public class ExcelRowFileOutputFormat
extends AbstractSpreadSheetDocumentFileOutputFormat<ArrayWritable>
implements Serializable {
    private static final long serialVersionUID = 8620371832156924952L;
    private static final Log LOG = LogFactory.getLog((String)ExcelRowFileOutputFormat.class.getName());

    @Override
    public RecordWriter<NullWritable, ArrayWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        String defaultConf = conf.get("hadoopoffice.write.mimeType", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        conf.set("hadoopoffice.write.mimeType", defaultConf);
        Path file = this.getDefaultWorkFile(context, ExcelFileOutputFormat.getSuffix(conf.get("hadoopoffice.write.mimeType")));
        try {
            return new ExcelRowRecordWriter<NullWritable, ArrayWritable>(HadoopUtil.getDataOutputStream(conf, file, (Progressable)context, ExcelRowFileOutputFormat.getCompressOutput((JobContext)context), ExcelRowFileOutputFormat.getOutputCompressorClass((JobContext)context, (Class)ExcelFileOutputFormat.defaultCompressorClass)), file.getName(), conf);
        }
        catch (GeneralSecurityException | FormatNotUnderstoodException | InvalidCellSpecificationException | InvalidWriterConfigurationException | OfficeWriterException e) {
            LOG.error((Object)e);
            return null;
        }
    }
}

