/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.util.msexcel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.apache.poi.poifs.crypt.dsig.SignatureInfo;
import org.apache.poi.poifs.crypt.dsig.facets.KeyInfoSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.OOXMLSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.Office2010SignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.XAdESSignatureFacet;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.TempFile;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;

public class MSExcelOOXMLSignUtil {
    private static final Log LOG = LogFactory.getLog((String)MSExcelOOXMLSignUtil.class.getName());
    private OutputStream finalOutputStream;
    private File tempSignFile;
    private FileOutputStream tempSignFileOS;

    public MSExcelOOXMLSignUtil(OutputStream finalOutputStream) throws IOException {
        this.finalOutputStream = finalOutputStream;
        LOG.info((Object)"Creating tempfile for signing");
        this.tempSignFile = TempFile.createTempFile("hadooffice-poi-temp-data-sign", ".tmp");
        this.tempSignFileOS = new FileOutputStream(this.tempSignFile);
    }

    public OutputStream getTempOutputStream() {
        return this.tempSignFileOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign(Key privateKey, List<X509Certificate> x509List, String password, HashAlgorithm hashAlgorithm) throws XMLSignatureException, MarshalException, IOException, FormatNotUnderstoodException {
        if (this.tempSignFileOS != null) {
            this.tempSignFileOS.close();
        }
        SignatureConfig sc = new SignatureConfig();
        sc.addSignatureFacet(new OOXMLSignatureFacet());
        sc.addSignatureFacet(new KeyInfoSignatureFacet());
        sc.addSignatureFacet(new XAdESSignatureFacet());
        sc.addSignatureFacet(new Office2010SignatureFacet());
        sc.setKey((PrivateKey)privateKey);
        sc.setSigningCertificateChain(x509List);
        sc.setDigestAlgo(hashAlgorithm);
        FileInputStream tempSignFileIS = null;
        try {
            FileInputStream tmpFileInputStream = new FileInputStream(this.tempSignFile);
            if (password == null) {
                this.signUnencryptedOpcPackage(tmpFileInputStream, sc);
            } else {
                this.signEncryptedPackage(tmpFileInputStream, sc, password);
            }
        }
        catch (IOException | InvalidFormatException e) {
            LOG.error((Object)e);
        }
        finally {
            if (this.finalOutputStream != null) {
                this.finalOutputStream.close();
            }
            if (tempSignFileIS != null) {
                tempSignFileIS.close();
            }
        }
    }

    private void signUnencryptedOpcPackage(InputStream tmpFileInputStream, SignatureConfig sc) throws InvalidFormatException, IOException, XMLSignatureException, MarshalException {
        OPCPackage pkg = OPCPackage.open(tmpFileInputStream);
        sc.setOpcPackage(pkg);
        Object originalPropertyValue = null;
        SignatureInfo si = new SignatureInfo();
        si.setSignatureConfig(sc);
        si.confirmSignature();
        pkg.save(this.finalOutputStream);
        pkg.close();
    }

    private void signEncryptedPackage(InputStream tmpFileInputStream, SignatureConfig sc, String password) throws IOException, InvalidFormatException, FormatNotUnderstoodException, XMLSignatureException, MarshalException {
        POIFSFileSystem poifsTemp = new POIFSFileSystem(tmpFileInputStream);
        EncryptionInfo info = new EncryptionInfo(poifsTemp);
        Decryptor d = Decryptor.getInstance(info);
        try {
            if (!d.verifyPassword(password)) {
                throw new FormatNotUnderstoodException("Error: Cannot decrypt new Excel file (.xlsx) for signing. Invalid password");
            }
            OPCPackage pkg = OPCPackage.open(d.getDataStream(poifsTemp));
            sc.setOpcPackage(pkg);
            SignatureInfo si = new SignatureInfo();
            si.setSignatureConfig(sc);
            si.confirmSignature();
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            POIFSFileSystem poifs = new POIFSFileSystem();
            OutputStream os = enc.getDataStream(poifs);
            pkg.save(os);
            pkg.close();
            if (os != null) {
                os.close();
            }
            poifs.writeFilesystem(this.finalOutputStream);
            if (poifs != null) {
                poifs.close();
            }
            if (poifsTemp != null) {
                poifsTemp.close();
            }
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)e);
            throw new FormatNotUnderstoodException("Error: Cannot decrypt new Excel file (.xlsx)  for signing.");
        }
    }

    public void close() throws IOException {
        try {
            if (this.tempSignFileOS != null) {
                this.tempSignFileOS.close();
            }
        }
        finally {
            if (!this.tempSignFile.delete()) {
                LOG.warn((Object)"Could not delete temporary files used for signing");
            }
        }
    }
}

