/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.writer.msexcel.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.zuinnote.hadoop.office.format.common.writer.msexcel.internal.EncryptedTempData;
import org.zuinnote.hadoop.office.format.common.writer.msexcel.internal.EncryptedZipEntrySource;

public class SecureSXSSFWorkbook
extends SXSSFWorkbook {
    private CipherAlgorithm ca;
    private ChainingMode cm;

    public SecureSXSSFWorkbook(int cacherows, CipherAlgorithm ca, ChainingMode cm) {
        super(cacherows);
        this.setCompressTempFiles(true);
        this.ca = ca;
        this.cm = cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream stream) throws IOException {
        this.flushSheets();
        EncryptedTempData tempData = new EncryptedTempData(this.ca, this.cm);
        EncryptedZipEntrySource source = null;
        OutputStream os = tempData.getOutputStream();
        try {
            this.getXSSFWorkbook().write(os);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
        source = new EncryptedZipEntrySource(this.ca, this.cm);
        source.setInputStream(tempData.getInputStream());
        this.injectData(source, stream);
        tempData.dispose();
    }
}

