/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.TuningTask;
import com.google.genai.types.VeoHyperParameters;
import java.util.Optional;

final class AutoValue_VeoHyperParameters
extends VeoHyperParameters {
    private final Optional<Long> epochCount;
    private final Optional<Double> learningRateMultiplier;
    private final Optional<TuningTask> tuningTask;

    private AutoValue_VeoHyperParameters(Optional<Long> epochCount, Optional<Double> learningRateMultiplier, Optional<TuningTask> tuningTask) {
        this.epochCount = epochCount;
        this.learningRateMultiplier = learningRateMultiplier;
        this.tuningTask = tuningTask;
    }

    @Override
    @JsonProperty(value="epochCount")
    public Optional<Long> epochCount() {
        return this.epochCount;
    }

    @Override
    @JsonProperty(value="learningRateMultiplier")
    public Optional<Double> learningRateMultiplier() {
        return this.learningRateMultiplier;
    }

    @Override
    @JsonProperty(value="tuningTask")
    public Optional<TuningTask> tuningTask() {
        return this.tuningTask;
    }

    public String toString() {
        return "VeoHyperParameters{epochCount=" + this.epochCount + ", learningRateMultiplier=" + this.learningRateMultiplier + ", tuningTask=" + this.tuningTask + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VeoHyperParameters) {
            VeoHyperParameters that = (VeoHyperParameters)o;
            return this.epochCount.equals(that.epochCount()) && this.learningRateMultiplier.equals(that.learningRateMultiplier()) && this.tuningTask.equals(that.tuningTask());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.epochCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.learningRateMultiplier.hashCode();
        h$ *= 1000003;
        return h$ ^= this.tuningTask.hashCode();
    }

    @Override
    public VeoHyperParameters.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends VeoHyperParameters.Builder {
        private Optional<Long> epochCount = Optional.empty();
        private Optional<Double> learningRateMultiplier = Optional.empty();
        private Optional<TuningTask> tuningTask = Optional.empty();

        Builder() {
        }

        Builder(VeoHyperParameters source) {
            this.epochCount = source.epochCount();
            this.learningRateMultiplier = source.learningRateMultiplier();
            this.tuningTask = source.tuningTask();
        }

        @Override
        public VeoHyperParameters.Builder epochCount(Long epochCount) {
            this.epochCount = Optional.of(epochCount);
            return this;
        }

        @Override
        public VeoHyperParameters.Builder learningRateMultiplier(Double learningRateMultiplier) {
            this.learningRateMultiplier = Optional.of(learningRateMultiplier);
            return this;
        }

        @Override
        public VeoHyperParameters.Builder tuningTask(TuningTask tuningTask) {
            this.tuningTask = Optional.of(tuningTask);
            return this;
        }

        @Override
        public VeoHyperParameters build() {
            return new AutoValue_VeoHyperParameters(this.epochCount, this.learningRateMultiplier, this.tuningTask);
        }
    }
}

