/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_FunctionResponse;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.FunctionResponsePart;
import com.google.genai.types.FunctionResponseScheduling;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class FunctionResponse
extends JsonSerializable {
    @JsonProperty(value="willContinue")
    public abstract Optional<Boolean> willContinue();

    @JsonProperty(value="scheduling")
    public abstract Optional<FunctionResponseScheduling> scheduling();

    @JsonProperty(value="parts")
    public abstract Optional<List<FunctionResponsePart>> parts();

    @JsonProperty(value="id")
    public abstract Optional<String> id();

    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="response")
    public abstract Optional<Map<String, Object>> response();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_FunctionResponse.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static FunctionResponse fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, FunctionResponse.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_FunctionResponse.Builder();
        }

        @JsonProperty(value="willContinue")
        public abstract Builder willContinue(boolean var1);

        @JsonProperty(value="scheduling")
        public abstract Builder scheduling(FunctionResponseScheduling var1);

        @CanIgnoreReturnValue
        public Builder scheduling(FunctionResponseScheduling.Known knownType) {
            return this.scheduling(new FunctionResponseScheduling(knownType));
        }

        @CanIgnoreReturnValue
        public Builder scheduling(String scheduling) {
            return this.scheduling(new FunctionResponseScheduling(scheduling));
        }

        @JsonProperty(value="parts")
        public abstract Builder parts(List<FunctionResponsePart> var1);

        public Builder parts(FunctionResponsePart ... parts) {
            return this.parts(Arrays.asList(parts));
        }

        public Builder parts(FunctionResponsePart.Builder ... partsBuilders) {
            return this.parts((List)Arrays.asList(partsBuilders).stream().map(FunctionResponsePart.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="response")
        public abstract Builder response(Map<String, Object> var1);

        public abstract FunctionResponse build();
    }
}

