/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerateContentConfig;
import com.google.genai.types.AutomaticFunctionCallingConfig;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerationConfigRoutingConfig;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ImageConfig;
import com.google.genai.types.MediaResolution;
import com.google.genai.types.ModelSelectionConfig;
import com.google.genai.types.SafetySetting;
import com.google.genai.types.Schema;
import com.google.genai.types.SpeechConfig;
import com.google.genai.types.ThinkingConfig;
import com.google.genai.types.Tool;
import com.google.genai.types.ToolConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerateContentConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="shouldReturnHttpResponse")
    public abstract Optional<Boolean> shouldReturnHttpResponse();

    @JsonProperty(value="systemInstruction")
    public abstract Optional<Content> systemInstruction();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    @JsonProperty(value="topK")
    public abstract Optional<Float> topK();

    @JsonProperty(value="candidateCount")
    public abstract Optional<Integer> candidateCount();

    @JsonProperty(value="maxOutputTokens")
    public abstract Optional<Integer> maxOutputTokens();

    @JsonProperty(value="stopSequences")
    public abstract Optional<List<String>> stopSequences();

    @JsonProperty(value="responseLogprobs")
    public abstract Optional<Boolean> responseLogprobs();

    @JsonProperty(value="logprobs")
    public abstract Optional<Integer> logprobs();

    @JsonProperty(value="presencePenalty")
    public abstract Optional<Float> presencePenalty();

    @JsonProperty(value="frequencyPenalty")
    public abstract Optional<Float> frequencyPenalty();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="responseMimeType")
    public abstract Optional<String> responseMimeType();

    @JsonProperty(value="responseSchema")
    public abstract Optional<Schema> responseSchema();

    @JsonProperty(value="responseJsonSchema")
    public abstract Optional<Object> responseJsonSchema();

    @JsonProperty(value="routingConfig")
    public abstract Optional<GenerationConfigRoutingConfig> routingConfig();

    @JsonProperty(value="modelSelectionConfig")
    public abstract Optional<ModelSelectionConfig> modelSelectionConfig();

    @JsonProperty(value="safetySettings")
    public abstract Optional<List<SafetySetting>> safetySettings();

    @JsonProperty(value="tools")
    public abstract Optional<List<Tool>> tools();

    @JsonProperty(value="toolConfig")
    public abstract Optional<ToolConfig> toolConfig();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="cachedContent")
    public abstract Optional<String> cachedContent();

    @JsonProperty(value="responseModalities")
    public abstract Optional<List<String>> responseModalities();

    @JsonProperty(value="mediaResolution")
    public abstract Optional<MediaResolution> mediaResolution();

    @JsonProperty(value="speechConfig")
    public abstract Optional<SpeechConfig> speechConfig();

    @JsonProperty(value="audioTimestamp")
    public abstract Optional<Boolean> audioTimestamp();

    @JsonProperty(value="automaticFunctionCalling")
    public abstract Optional<AutomaticFunctionCallingConfig> automaticFunctionCalling();

    @JsonProperty(value="thinkingConfig")
    public abstract Optional<ThinkingConfig> thinkingConfig();

    @JsonProperty(value="imageConfig")
    public abstract Optional<ImageConfig> imageConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GenerateContentConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GenerateContentConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateContentConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerateContentConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @JsonProperty(value="shouldReturnHttpResponse")
        public abstract Builder shouldReturnHttpResponse(boolean var1);

        @JsonProperty(value="systemInstruction")
        public abstract Builder systemInstruction(Content var1);

        public Builder systemInstruction(Content.Builder systemInstructionBuilder) {
            return this.systemInstruction(systemInstructionBuilder.build());
        }

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        @JsonProperty(value="topK")
        public abstract Builder topK(Float var1);

        @JsonProperty(value="candidateCount")
        public abstract Builder candidateCount(Integer var1);

        @JsonProperty(value="maxOutputTokens")
        public abstract Builder maxOutputTokens(Integer var1);

        @JsonProperty(value="stopSequences")
        public abstract Builder stopSequences(List<String> var1);

        public Builder stopSequences(String ... stopSequences) {
            return this.stopSequences(Arrays.asList(stopSequences));
        }

        @JsonProperty(value="responseLogprobs")
        public abstract Builder responseLogprobs(boolean var1);

        @JsonProperty(value="logprobs")
        public abstract Builder logprobs(Integer var1);

        @JsonProperty(value="presencePenalty")
        public abstract Builder presencePenalty(Float var1);

        @JsonProperty(value="frequencyPenalty")
        public abstract Builder frequencyPenalty(Float var1);

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @JsonProperty(value="responseMimeType")
        public abstract Builder responseMimeType(String var1);

        @JsonProperty(value="responseSchema")
        public abstract Builder responseSchema(Schema var1);

        public Builder responseSchema(Schema.Builder responseSchemaBuilder) {
            return this.responseSchema(responseSchemaBuilder.build());
        }

        @JsonProperty(value="responseJsonSchema")
        public abstract Builder responseJsonSchema(Object var1);

        @JsonProperty(value="routingConfig")
        public abstract Builder routingConfig(GenerationConfigRoutingConfig var1);

        public Builder routingConfig(GenerationConfigRoutingConfig.Builder routingConfigBuilder) {
            return this.routingConfig(routingConfigBuilder.build());
        }

        @JsonProperty(value="modelSelectionConfig")
        public abstract Builder modelSelectionConfig(ModelSelectionConfig var1);

        public Builder modelSelectionConfig(ModelSelectionConfig.Builder modelSelectionConfigBuilder) {
            return this.modelSelectionConfig(modelSelectionConfigBuilder.build());
        }

        @JsonProperty(value="safetySettings")
        public abstract Builder safetySettings(List<SafetySetting> var1);

        public Builder safetySettings(SafetySetting ... safetySettings) {
            return this.safetySettings(Arrays.asList(safetySettings));
        }

        public Builder safetySettings(SafetySetting.Builder ... safetySettingsBuilders) {
            return this.safetySettings((List)Arrays.asList(safetySettingsBuilders).stream().map(SafetySetting.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="tools")
        public abstract Builder tools(List<Tool> var1);

        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        public Builder tools(Tool.Builder ... toolsBuilders) {
            return this.tools((List)Arrays.asList(toolsBuilders).stream().map(Tool.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="toolConfig")
        public abstract Builder toolConfig(ToolConfig var1);

        public Builder toolConfig(ToolConfig.Builder toolConfigBuilder) {
            return this.toolConfig(toolConfigBuilder.build());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @JsonProperty(value="cachedContent")
        public abstract Builder cachedContent(String var1);

        @JsonProperty(value="responseModalities")
        public abstract Builder responseModalities(List<String> var1);

        public Builder responseModalities(String ... responseModalities) {
            return this.responseModalities(Arrays.asList(responseModalities));
        }

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(MediaResolution var1);

        @CanIgnoreReturnValue
        public Builder mediaResolution(MediaResolution.Known knownType) {
            return this.mediaResolution(new MediaResolution(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(String mediaResolution) {
            return this.mediaResolution(new MediaResolution(mediaResolution));
        }

        @JsonProperty(value="speechConfig")
        public abstract Builder speechConfig(SpeechConfig var1);

        public Builder speechConfig(SpeechConfig.Builder speechConfigBuilder) {
            return this.speechConfig(speechConfigBuilder.build());
        }

        @JsonProperty(value="audioTimestamp")
        public abstract Builder audioTimestamp(boolean var1);

        @JsonProperty(value="automaticFunctionCalling")
        public abstract Builder automaticFunctionCalling(AutomaticFunctionCallingConfig var1);

        public Builder automaticFunctionCalling(AutomaticFunctionCallingConfig.Builder automaticFunctionCallingBuilder) {
            return this.automaticFunctionCalling(automaticFunctionCallingBuilder.build());
        }

        @JsonProperty(value="thinkingConfig")
        public abstract Builder thinkingConfig(ThinkingConfig var1);

        public Builder thinkingConfig(ThinkingConfig.Builder thinkingConfigBuilder) {
            return this.thinkingConfig(thinkingConfigBuilder.build());
        }

        @JsonProperty(value="imageConfig")
        public abstract Builder imageConfig(ImageConfig var1);

        public Builder imageConfig(ImageConfig.Builder imageConfigBuilder) {
            return this.imageConfig(imageConfigBuilder.build());
        }

        public abstract GenerateContentConfig build();
    }
}

