/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GroundingMetadata;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GroundingChunk;
import com.google.genai.types.GroundingMetadataSourceFlaggingUri;
import com.google.genai.types.GroundingSupport;
import com.google.genai.types.RetrievalMetadata;
import com.google.genai.types.SearchEntryPoint;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GroundingMetadata
extends JsonSerializable {
    @JsonProperty(value="googleMapsWidgetContextToken")
    public abstract Optional<String> googleMapsWidgetContextToken();

    @JsonProperty(value="groundingChunks")
    public abstract Optional<List<GroundingChunk>> groundingChunks();

    @JsonProperty(value="groundingSupports")
    public abstract Optional<List<GroundingSupport>> groundingSupports();

    @JsonProperty(value="retrievalMetadata")
    public abstract Optional<RetrievalMetadata> retrievalMetadata();

    @JsonProperty(value="retrievalQueries")
    public abstract Optional<List<String>> retrievalQueries();

    @JsonProperty(value="searchEntryPoint")
    public abstract Optional<SearchEntryPoint> searchEntryPoint();

    @JsonProperty(value="sourceFlaggingUris")
    public abstract Optional<List<GroundingMetadataSourceFlaggingUri>> sourceFlaggingUris();

    @JsonProperty(value="webSearchQueries")
    public abstract Optional<List<String>> webSearchQueries();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GroundingMetadata.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GroundingMetadata fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GroundingMetadata.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GroundingMetadata.Builder();
        }

        @JsonProperty(value="googleMapsWidgetContextToken")
        public abstract Builder googleMapsWidgetContextToken(String var1);

        @JsonProperty(value="groundingChunks")
        public abstract Builder groundingChunks(List<GroundingChunk> var1);

        public Builder groundingChunks(GroundingChunk ... groundingChunks) {
            return this.groundingChunks(Arrays.asList(groundingChunks));
        }

        public Builder groundingChunks(GroundingChunk.Builder ... groundingChunksBuilders) {
            return this.groundingChunks((List)Arrays.asList(groundingChunksBuilders).stream().map(GroundingChunk.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="groundingSupports")
        public abstract Builder groundingSupports(List<GroundingSupport> var1);

        public Builder groundingSupports(GroundingSupport ... groundingSupports) {
            return this.groundingSupports(Arrays.asList(groundingSupports));
        }

        public Builder groundingSupports(GroundingSupport.Builder ... groundingSupportsBuilders) {
            return this.groundingSupports((List)Arrays.asList(groundingSupportsBuilders).stream().map(GroundingSupport.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="retrievalMetadata")
        public abstract Builder retrievalMetadata(RetrievalMetadata var1);

        public Builder retrievalMetadata(RetrievalMetadata.Builder retrievalMetadataBuilder) {
            return this.retrievalMetadata(retrievalMetadataBuilder.build());
        }

        @JsonProperty(value="retrievalQueries")
        public abstract Builder retrievalQueries(List<String> var1);

        public Builder retrievalQueries(String ... retrievalQueries) {
            return this.retrievalQueries(Arrays.asList(retrievalQueries));
        }

        @JsonProperty(value="searchEntryPoint")
        public abstract Builder searchEntryPoint(SearchEntryPoint var1);

        public Builder searchEntryPoint(SearchEntryPoint.Builder searchEntryPointBuilder) {
            return this.searchEntryPoint(searchEntryPointBuilder.build());
        }

        @JsonProperty(value="sourceFlaggingUris")
        public abstract Builder sourceFlaggingUris(List<GroundingMetadataSourceFlaggingUri> var1);

        public Builder sourceFlaggingUris(GroundingMetadataSourceFlaggingUri ... sourceFlaggingUris) {
            return this.sourceFlaggingUris(Arrays.asList(sourceFlaggingUris));
        }

        public Builder sourceFlaggingUris(GroundingMetadataSourceFlaggingUri.Builder ... sourceFlaggingUrisBuilders) {
            return this.sourceFlaggingUris((List)Arrays.asList(sourceFlaggingUrisBuilders).stream().map(GroundingMetadataSourceFlaggingUri.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="webSearchQueries")
        public abstract Builder webSearchQueries(List<String> var1);

        public Builder webSearchQueries(String ... webSearchQueries) {
            return this.webSearchQueries(Arrays.asList(webSearchQueries));
        }

        public abstract GroundingMetadata build();
    }
}

