/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Model;
import com.google.genai.types.Checkpoint;
import com.google.genai.types.Endpoint;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TunedModelInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Model
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="version")
    public abstract Optional<String> version();

    @JsonProperty(value="endpoints")
    public abstract Optional<List<Endpoint>> endpoints();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="tunedModelInfo")
    public abstract Optional<TunedModelInfo> tunedModelInfo();

    @JsonProperty(value="inputTokenLimit")
    public abstract Optional<Integer> inputTokenLimit();

    @JsonProperty(value="outputTokenLimit")
    public abstract Optional<Integer> outputTokenLimit();

    @JsonProperty(value="supportedActions")
    public abstract Optional<List<String>> supportedActions();

    @JsonProperty(value="defaultCheckpointId")
    public abstract Optional<String> defaultCheckpointId();

    @JsonProperty(value="checkpoints")
    public abstract Optional<List<Checkpoint>> checkpoints();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Model.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Model fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Model.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Model.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="version")
        public abstract Builder version(String var1);

        @JsonProperty(value="endpoints")
        public abstract Builder endpoints(List<Endpoint> var1);

        public Builder endpoints(Endpoint ... endpoints) {
            return this.endpoints(Arrays.asList(endpoints));
        }

        public Builder endpoints(Endpoint.Builder ... endpointsBuilders) {
            return this.endpoints((List)Arrays.asList(endpointsBuilders).stream().map(Endpoint.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @JsonProperty(value="tunedModelInfo")
        public abstract Builder tunedModelInfo(TunedModelInfo var1);

        public Builder tunedModelInfo(TunedModelInfo.Builder tunedModelInfoBuilder) {
            return this.tunedModelInfo(tunedModelInfoBuilder.build());
        }

        @JsonProperty(value="inputTokenLimit")
        public abstract Builder inputTokenLimit(Integer var1);

        @JsonProperty(value="outputTokenLimit")
        public abstract Builder outputTokenLimit(Integer var1);

        @JsonProperty(value="supportedActions")
        public abstract Builder supportedActions(List<String> var1);

        public Builder supportedActions(String ... supportedActions) {
            return this.supportedActions(Arrays.asList(supportedActions));
        }

        @JsonProperty(value="defaultCheckpointId")
        public abstract Builder defaultCheckpointId(String var1);

        @JsonProperty(value="checkpoints")
        public abstract Builder checkpoints(List<Checkpoint> var1);

        public Builder checkpoints(Checkpoint ... checkpoints) {
            return this.checkpoints(Arrays.asList(checkpoints));
        }

        public Builder checkpoints(Checkpoint.Builder ... checkpointsBuilders) {
            return this.checkpoints((List)Arrays.asList(checkpointsBuilders).stream().map(Checkpoint.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        public abstract Model build();
    }
}

