/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Schema;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Schema
extends JsonSerializable {
    @JsonProperty(value="anyOf")
    public abstract Optional<List<Schema>> anyOf();

    @JsonProperty(value="default")
    public abstract Optional<Object> default_();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="enum")
    public abstract Optional<List<String>> enum_();

    @JsonProperty(value="example")
    public abstract Optional<Object> example();

    @JsonProperty(value="format")
    public abstract Optional<String> format();

    @JsonProperty(value="items")
    public abstract Optional<Schema> items();

    @JsonProperty(value="maxItems")
    public abstract Optional<Long> maxItems();

    @JsonProperty(value="maxLength")
    public abstract Optional<Long> maxLength();

    @JsonProperty(value="maxProperties")
    public abstract Optional<Long> maxProperties();

    @JsonProperty(value="maximum")
    public abstract Optional<Double> maximum();

    @JsonProperty(value="minItems")
    public abstract Optional<Long> minItems();

    @JsonProperty(value="minLength")
    public abstract Optional<Long> minLength();

    @JsonProperty(value="minProperties")
    public abstract Optional<Long> minProperties();

    @JsonProperty(value="minimum")
    public abstract Optional<Double> minimum();

    @JsonProperty(value="nullable")
    public abstract Optional<Boolean> nullable();

    @JsonProperty(value="pattern")
    public abstract Optional<String> pattern();

    @JsonProperty(value="properties")
    public abstract Optional<Map<String, Schema>> properties();

    @JsonProperty(value="propertyOrdering")
    public abstract Optional<List<String>> propertyOrdering();

    @JsonProperty(value="required")
    public abstract Optional<List<String>> required();

    @JsonProperty(value="title")
    public abstract Optional<String> title();

    @JsonProperty(value="type")
    public abstract Optional<Type> type();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Schema.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Schema fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Schema.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Schema.Builder();
        }

        @JsonProperty(value="anyOf")
        public abstract Builder anyOf(List<Schema> var1);

        public Builder anyOf(Schema ... anyOf) {
            return this.anyOf(Arrays.asList(anyOf));
        }

        public Builder anyOf(Builder ... anyOfBuilders) {
            return this.anyOf((List)Arrays.asList(anyOfBuilders).stream().map(Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="default")
        public abstract Builder default_(Object var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="enum")
        public abstract Builder enum_(List<String> var1);

        public Builder enum_(String ... enum_) {
            return this.enum_(Arrays.asList(enum_));
        }

        @JsonProperty(value="example")
        public abstract Builder example(Object var1);

        @JsonProperty(value="format")
        public abstract Builder format(String var1);

        @JsonProperty(value="items")
        public abstract Builder items(Schema var1);

        public Builder items(Builder itemsBuilder) {
            return this.items(itemsBuilder.build());
        }

        @JsonProperty(value="maxItems")
        public abstract Builder maxItems(Long var1);

        @JsonProperty(value="maxLength")
        public abstract Builder maxLength(Long var1);

        @JsonProperty(value="maxProperties")
        public abstract Builder maxProperties(Long var1);

        @JsonProperty(value="maximum")
        public abstract Builder maximum(Double var1);

        @JsonProperty(value="minItems")
        public abstract Builder minItems(Long var1);

        @JsonProperty(value="minLength")
        public abstract Builder minLength(Long var1);

        @JsonProperty(value="minProperties")
        public abstract Builder minProperties(Long var1);

        @JsonProperty(value="minimum")
        public abstract Builder minimum(Double var1);

        @JsonProperty(value="nullable")
        public abstract Builder nullable(boolean var1);

        @JsonProperty(value="pattern")
        public abstract Builder pattern(String var1);

        @JsonProperty(value="properties")
        public abstract Builder properties(Map<String, Schema> var1);

        @JsonProperty(value="propertyOrdering")
        public abstract Builder propertyOrdering(List<String> var1);

        public Builder propertyOrdering(String ... propertyOrdering) {
            return this.propertyOrdering(Arrays.asList(propertyOrdering));
        }

        @JsonProperty(value="required")
        public abstract Builder required(List<String> var1);

        public Builder required(String ... required) {
            return this.required(Arrays.asList(required));
        }

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="type")
        public abstract Builder type(Type var1);

        @CanIgnoreReturnValue
        public Builder type(Type.Known knownType) {
            return this.type(new Type(knownType));
        }

        @CanIgnoreReturnValue
        public Builder type(String type) {
            return this.type(new Type(type));
        }

        public abstract Schema build();
    }
}

