/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractCollectionTestSuiteBuilder;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public class CollectionTestSuiteBuilder<E>
extends AbstractCollectionTestSuiteBuilder<CollectionTestSuiteBuilder<E>, E> {
    public static <E> CollectionTestSuiteBuilder<E> using(TestCollectionGenerator<E> generator) {
        return (CollectionTestSuiteBuilder)new CollectionTestSuiteBuilder<E>().usingGenerator(generator);
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        ArrayList<TestSuite> derivedSuites = new ArrayList<TestSuite>(super.createDerivedSuites(parentBuilder));
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using(new ReserializedCollectionGenerator(parentBuilder.getSubjectGenerator())).named(this.getName() + " reserialized")).withFeatures(CollectionTestSuiteBuilder.computeReserializedCollectionFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        }
        return derivedSuites;
    }

    private static Set<Feature<?>> computeReserializedCollectionFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet(features);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    static class ReserializedCollectionGenerator<E>
    implements TestCollectionGenerator<E> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        private ReserializedCollectionGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<E> samples() {
            return this.gen.samples();
        }

        @Override
        public Collection<E> create(Object ... elements) {
            return SerializableTester.reserialize((Collection)this.gen.create(elements));
        }

        @Override
        public E[] createArray(int length) {
            return this.gen.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.gen.order(insertionOrder);
        }
    }
}

