/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestEnumMapGenerator;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.TestUnhashableCollectionGenerator;
import com.google.common.collect.testing.UnhashableObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible
public class MapGenerators {

    public static class ImmutableMapValuesAsSingletonSetGenerator
    implements TestMapGenerator<String, Collection<Integer>> {
        @Override
        public SampleElements<Map.Entry<String, Collection<Integer>>> samples() {
            return new SampleElements<Map.Entry<String, Collection<Integer>>>(Helpers.mapEntry("one", ImmutableSet.of((Object)10000)), Helpers.mapEntry("two", ImmutableSet.of((Object)-2000)), Helpers.mapEntry("three", ImmutableSet.of((Object)300)), Helpers.mapEntry("four", ImmutableSet.of((Object)-40)), Helpers.mapEntry("five", ImmutableSet.of((Object)5)));
        }

        @Override
        public Map<String, Collection<Integer>> create(Object ... elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Object elem : elements) {
                Map.Entry entry = (Map.Entry)elem;
                Integer value = (Integer)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()));
                builder.put((Object)((String)entry.getKey()), (Object)value);
            }
            return builder.buildOrThrow().asMultimap().asMap();
        }

        public Map.Entry<String, Collection<Integer>>[] createArray(int length) {
            return new Map.Entry[length];
        }

        @Override
        public Iterable<Map.Entry<String, Collection<Integer>>> order(List<Map.Entry<String, Collection<Integer>>> insertionOrder) {
            return insertionOrder;
        }

        public String[] createKeyArray(int length) {
            return new String[length];
        }

        public Collection<Integer>[] createValueArray(int length) {
            return new ImmutableSet[length];
        }
    }

    public static class ImmutableMapCopyOfEnumMapGenerator
    extends TestEnumMapGenerator {
        @Override
        protected Map<AnEnum, String> create(Map.Entry<AnEnum, String>[] entries) {
            EnumMap<AnEnum, String> map = new EnumMap<AnEnum, String>(AnEnum.class);
            for (Map.Entry<AnEnum, String> entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
            return ImmutableMap.copyOf(map);
        }

        @Override
        public Iterable<Map.Entry<AnEnum, String>> order(List<Map.Entry<AnEnum, String>> insertionOrder) {
            return new Ordering<Map.Entry<AnEnum, String>>(){

                public int compare(Map.Entry<AnEnum, String> left, Map.Entry<AnEnum, String> right) {
                    return left.getKey().compareTo(right.getKey());
                }
            }.sortedCopy(insertionOrder);
        }
    }

    public static class ImmutableEnumMapGenerator
    extends TestEnumMapGenerator {
        @Override
        protected Map<AnEnum, String> create(Map.Entry<AnEnum, String>[] entries) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry<AnEnum, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                map.put(entry.getKey(), entry.getValue());
            }
            return Maps.immutableEnumMap((Map)map);
        }
    }

    public static class ImmutableMapEntryListGenerator
    implements TestListGenerator<Map.Entry<String, Integer>> {
        @Override
        public SampleElements<Map.Entry<String, Integer>> samples() {
            return new SampleElements<Map.Entry<String, Integer>>(Helpers.mapEntry("foo", 5), Helpers.mapEntry("bar", 3), Helpers.mapEntry("baz", 17), Helpers.mapEntry("quux", 1), Helpers.mapEntry("toaster", -2));
        }

        public Map.Entry<String, Integer>[] createArray(int length) {
            return new Map.Entry[length];
        }

        @Override
        public Iterable<Map.Entry<String, Integer>> order(List<Map.Entry<String, Integer>> insertionOrder) {
            return insertionOrder;
        }

        @Override
        public List<Map.Entry<String, Integer>> create(Object ... elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Object o : elements) {
                Map.Entry entry = (Map.Entry)Preconditions.checkNotNull((Object)o);
                builder.put(entry);
            }
            return builder.buildOrThrow().entrySet().asList();
        }
    }

    public static class ImmutableMapValueListGenerator
    extends TestStringListGenerator {
        @Override
        public List<String> create(String[] elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)i, (Object)elements[i]);
            }
            return builder.buildOrThrow().values().asList();
        }
    }

    public static class ImmutableMapKeyListGenerator
    extends TestStringListGenerator {
        @Override
        public List<String> create(String[] elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)elements[i], (Object)i);
            }
            return builder.buildOrThrow().keySet().asList();
        }
    }

    public static class ImmutableMapUnhashableValuesGenerator
    extends TestUnhashableCollectionGenerator<Collection<UnhashableObject>> {
        @Override
        public Collection<UnhashableObject> create(UnhashableObject[] elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int key = 1;
            for (UnhashableObject value : elements) {
                builder.put((Object)key++, (Object)value);
            }
            return builder.buildOrThrow().values();
        }
    }

    public static class ImmutableMapCopyOfEntriesGenerator
    extends TestStringMapGenerator {
        @Override
        protected Map<String, String> create(Map.Entry<String, String>[] entries) {
            return ImmutableMap.copyOf(Arrays.asList(entries));
        }
    }

    public static class ImmutableMapCopyOfGenerator
    extends TestStringMapGenerator {
        @Override
        protected Map<String, String> create(Map.Entry<String, String>[] entries) {
            LinkedHashMap builder = Maps.newLinkedHashMap();
            for (Map.Entry<String, String> entry : entries) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return ImmutableMap.copyOf((Map)builder);
        }
    }

    public static class ImmutableMapGenerator
    extends TestStringMapGenerator {
        @Override
        protected Map<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.buildOrThrow();
        }
    }
}

