/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class CollectionToStringTester<E>
extends AbstractCollectionTester<E> {
    public void testToString_minimal() {
        CollectionToStringTester.assertNotNull((String)"toString() should not return null", (Object)this.collection.toString());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToString_size0() {
        CollectionToStringTester.assertEquals((String)"emptyCollection.toString should return []", (String)"[]", (String)this.collection.toString());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToString_size1() {
        CollectionToStringTester.assertEquals((String)"size1Collection.toString should return [{element}]", (String)("[" + this.e0() + "]"), (String)this.collection.toString());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER}, absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToString_sizeSeveral() {
        String expected = Helpers.copyToList(this.getOrderedElements()).toString();
        CollectionToStringTester.assertEquals((String)"collection.toString() incorrect", (String)expected, (String)this.collection.toString());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testToString_null() {
        this.initCollectionWithNullElement();
        this.testToString_minimal();
    }
}

