/*
 * Decompiled with CFR 0.152.
 */
package com.helger.annotation;

import com.helger.annotation.RegEx;
import com.helger.annotation.meta.TypeQualifierValidator;
import com.helger.annotation.meta.When;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MatchesPattern {
    @RegEx
    public String value();

    public int flags() default 0;

    public static class Checker
    implements TypeQualifierValidator<MatchesPattern> {
        @Override
        public When forConstantValue(MatchesPattern matchesPattern, Object object) {
            Pattern pattern = Pattern.compile(matchesPattern.value(), matchesPattern.flags());
            if (pattern.matcher((String)object).matches()) {
                return When.ALWAYS;
            }
            return When.NEVER;
        }
    }
}

