/*
 * Decompiled with CFR 0.152.
 */
package com.helger.annotation;

import com.helger.annotation.meta.TypeQualifierValidator;
import com.helger.annotation.meta.When;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.METHOD})
@Documented
public @interface Nonempty {
    public When when() default When.ALWAYS;

    public static class Checker
    implements TypeQualifierValidator<Nonempty> {
        @Override
        public When forConstantValue(Nonempty nonempty, Object object) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.length() == 0) {
                    return When.NEVER;
                }
                return When.ALWAYS;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                if (collection.isEmpty()) {
                    return When.NEVER;
                }
                return When.ALWAYS;
            }
            return When.NEVER;
        }
    }
}

