/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.IEncoder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;

@FunctionalInterface
public interface IByteArrayEncoder
extends IEncoder<byte[], byte[]> {
    @Nonnegative
    default public int getMaximumEncodedLength(@Nonnegative int n) {
        return n;
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public byte[] getEncoded(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.getEncoded(byArray, 0, byArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public byte[] getEncoded(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    @Nullable
    @ReturnsMutableCopy
    default public byte[] getEncoded(@Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getEncoded(byArray);
    }
}

