/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonnegative;
import com.helger.base.io.stream.WrappedReader;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Reader;

public class CountingReader
extends WrappedReader {
    private long m_nCharsRead = 0L;
    private long m_nPosition = 0L;
    private long m_nMark = 0L;

    public CountingReader(@Nonnull Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_nCharsRead;
            ++this.m_nPosition;
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 != -1) {
            this.m_nCharsRead += (long)n3;
            this.m_nPosition += (long)n3;
        }
        return n3;
    }

    @Override
    public long skip(@Nonnegative long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.m_nPosition += l2;
        }
        return l2;
    }

    @Override
    public void mark(@Nonnegative int n) throws IOException {
        super.mark(n);
        this.m_nMark = this.m_nPosition;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.m_nPosition = this.m_nMark;
    }

    @Nonnegative
    public final long getCharsRead() {
        return this.m_nCharsRead;
    }

    @Nonnegative
    public final long getPosition() {
        return this.m_nPosition;
    }

    @Nonnegative
    public final long getMark() {
        return this.m_nMark;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("CharsRead", this.m_nCharsRead).append("Position", this.m_nPosition).append("Mark", this.m_nMark).getToString();
    }
}

