/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.io.EAppend;
import com.helger.base.io.iface.IHasOutputStreamAndWriter;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;

public class ByteArrayOutputStreamProvider
implements IHasOutputStreamAndWriter {
    private final NonBlockingByteArrayOutputStream m_aOS = new NonBlockingByteArrayOutputStream();

    @Override
    @Nonnull
    public final NonBlockingByteArrayOutputStream getOutputStream(@Nonnull EAppend eAppend) {
        if (eAppend.isTruncate()) {
            this.m_aOS.reset();
        }
        return this.m_aOS;
    }

    @Override
    public final boolean isWriteMultiple() {
        return true;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final byte[] getBytes() {
        return this.m_aOS.toByteArray();
    }

    @Nonnull
    public final String getAsString(@Nonnull Charset charset) {
        return this.m_aOS.getAsString(charset);
    }

    public String toString() {
        return new ToStringGenerator(this).append("os", this.m_aOS).getToString();
    }
}

