/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.cleanup;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.cleanup.ICleanUpRegistrarSPI;
import com.helger.base.cleanup.ICleanUpRegistry;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.spi.ServiceLoaderHelper;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CleanUpRegistry
implements ICleanUpRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanUpRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final List<Item> m_aActions = new ArrayList<Item>();

    private CleanUpRegistry() {
        this._reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static CleanUpRegistry getInstance() {
        CleanUpRegistry cleanUpRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return cleanUpRegistry;
    }

    private void _reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aActions.clear();
            for (ICleanUpRegistrarSPI iCleanUpRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(ICleanUpRegistrarSPI.class)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Calling registerCleanUpAction on " + iCleanUpRegistrarSPI.getClass().getName());
                }
                iCleanUpRegistrarSPI.registerCleanUpAction(this);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registered " + this.m_aActions.size() + " cleanup actions");
            }
        });
    }

    public void reinitialize() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitializing " + this.getClass().getName());
        }
        this._reinitialize();
    }

    @Override
    public void registerCleanup(int n, @Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "Runnable");
        this.m_aRWLock.writeLocked(() -> {
            this.m_aActions.add(new Item(n, runnable));
            Collections.sort(this.m_aActions);
        });
    }

    public void performCleanUp() {
        List list = this.m_aRWLock.readLockedGet(() -> new ArrayList<Item>(this.m_aActions));
        LOGGER.info("Running " + list.size() + " cleanup actions");
        for (Item item : list) {
            item.m_aRunnable.run();
        }
    }

    private static final class SingletonHolder {
        private static final CleanUpRegistry INSTANCE = new CleanUpRegistry();

        private SingletonHolder() {
        }
    }

    private static final class Item
    implements Comparable<Item> {
        private final int m_nPriority;
        private final Runnable m_aRunnable;

        private Item(int n, Runnable runnable) {
            this.m_nPriority = n;
            this.m_aRunnable = runnable;
        }

        @Override
        public int compareTo(@Nonnull Item item) {
            return Integer.compare(this.m_nPriority, item.m_nPriority);
        }
    }
}

