/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStreamAndReader;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;

public class ByteBufferInputStreamProvider
implements IHasInputStreamAndReader {
    private final ByteBuffer m_aBuffer;

    public ByteBufferInputStreamProvider(@Nonnull ByteBuffer byteBuffer) {
        this.m_aBuffer = ValueEnforcer.notNull(byteBuffer, "Buffer");
    }

    @Nonnull
    @ReturnsMutableObject
    public final ByteBuffer getByteBuffer() {
        return this.m_aBuffer;
    }

    @Override
    @Nonnull
    public final ByteBufferInputStream getInputStream() {
        return new ByteBufferInputStream(this.m_aBuffer);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    public String toString() {
        return new ToStringGenerator(null).append("buffer", this.m_aBuffer).getToString();
    }
}

