/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.map.AbstractSoftMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.function.Predicate;

public class SoftLinkedHashMap<K, V>
extends AbstractSoftMap<K, V> {
    private final int m_nMaxSize;

    public SoftLinkedHashMap(@Nonnegative int n) {
        super(new InternalLinkedHashMap(n));
        this.m_nMaxSize = n;
        ((InternalLinkedHashMap)this.m_aSrcMap).m_aFilter = entry -> {
            int n = this.size();
            if (n <= this.m_nMaxSize) {
                return false;
            }
            this.onRemoveEldestEntry(n, (Map.Entry<K, V>)entry);
            return true;
        };
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull Map.Entry<K, V> entry) {
    }

    @Nonnull
    @ReturnsMutableCopy
    public SoftLinkedHashMap<K, V> getClone() {
        SoftLinkedHashMap<K, V> softLinkedHashMap = new SoftLinkedHashMap<K, V>(this.m_nMaxSize);
        softLinkedHashMap.putAll(this);
        return softLinkedHashMap;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SoftLinkedHashMap softLinkedHashMap = (SoftLinkedHashMap)object;
        return this.m_nMaxSize == softLinkedHashMap.m_nMaxSize;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_nMaxSize).getHashCode();
    }

    private static class InternalLinkedHashMap<K, V>
    extends CommonsLinkedHashMap<K, AbstractSoftMap.SoftValue<K, V>> {
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private transient Predicate<? super Map.Entry<K, V>> m_aFilter;

        public InternalLinkedHashMap(@Nonnegative int n) {
            super(n, 0.75f, true);
        }

        @Override
        protected final boolean removeEldestEntry(@Nonnull Map.Entry<K, AbstractSoftMap.SoftValue<K, V>> entry) {
            Map.Entry entry2 = Map.entry(entry.getKey(), entry.getValue().get());
            return this.m_aFilter.test(entry2);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

