/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang.proxy;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.string.StringHex;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInvocationHandler
implements InvocationHandler {
    public static final boolean DEFAULT_PROXY_RETURN_VALUES = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingInvocationHandler.class);
    private final Object m_aActualTarget;
    private final String m_sLogPrefix;
    private boolean m_bProxyReturnValues = true;

    public LoggingInvocationHandler(@Nonnull Object object) {
        this.m_aActualTarget = object;
        this.m_sLogPrefix = "[@" + StringHex.getHexStringLeadingZero((int)System.identityHashCode(object), (int)8) + "] ";
    }

    public boolean isProxyReturnValues() {
        return this.m_bProxyReturnValues;
    }

    @Nonnull
    public LoggingInvocationHandler setProxyReturnValues(boolean bl) {
        this.m_bProxyReturnValues = bl;
        return this;
    }

    @Nonnull
    private static String _getParameter(@Nullable Parameter[] parameterArray, @Nullable Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (parameterArray != null) {
            int n = parameterArray.length;
            for (int i = 0; i < n; ++i) {
                Parameter parameter = parameterArray[i];
                Object object = objectArray[i];
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(parameter.getType().getSimpleName()).append(' ').append(parameter.getName()).append(" = ").append(object);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public Object invoke(@Nonnull Object object, @Nonnull Method method, @Nonnull Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getReturnType();
        String string = this.m_sLogPrefix + clazz.getSimpleName() + " " + this.m_aActualTarget.getClass().getSimpleName() + "." + method.getName() + " (" + LoggingInvocationHandler._getParameter(method.getParameters(), objectArray) + ")";
        LOGGER.info(string + " - invoke");
        Object object2 = method.invoke(this.m_aActualTarget, objectArray);
        if (clazz == Void.TYPE) {
            LOGGER.info(string + " - return");
            return null;
        }
        if (object2 == null) {
            LOGGER.info(string + " - return null");
            return null;
        }
        LOGGER.info(string + " - return " + String.valueOf(object2));
        if (this.m_bProxyReturnValues && clazz.isInterface()) {
            return LoggingInvocationHandler.proxying(clazz, object2);
        }
        return object2;
    }

    @Nonnull
    public static <T> T proxying(@Nonnull Class<? extends T> clazz, @Nonnull T t) {
        return (T)LoggingInvocationHandler.proxying(clazz, t, LoggingInvocationHandler::new);
    }

    @Nonnull
    public static <T> T proxying(@Nonnull Class<? extends T> clazz, @Nonnull T t, @Nonnull Function<? super T, ? extends InvocationHandler> function) {
        ValueEnforcer.isTrue((boolean)clazz.isInterface(), (String)"Only interface classes can be proxied!");
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, function.apply(t));
        return (T)GenericReflection.uncheckedCast((Object)object);
    }
}

