/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.graph.IMutableGraphNode;
import com.helger.graph.IMutableGraphRelation;
import com.helger.graph.impl.AbstractBaseGraphObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class GraphRelation
extends AbstractBaseGraphObject
implements IMutableGraphRelation {
    private final IMutableGraphNode m_aNode1;
    private final IMutableGraphNode m_aNode2;

    public GraphRelation(@Nonnull IMutableGraphNode iMutableGraphNode, @Nonnull IMutableGraphNode iMutableGraphNode2) {
        this(null, iMutableGraphNode, iMutableGraphNode2);
    }

    public GraphRelation(@Nullable String string, @Nonnull IMutableGraphNode iMutableGraphNode, @Nonnull IMutableGraphNode iMutableGraphNode2) {
        super(string);
        ValueEnforcer.notNull((Object)iMutableGraphNode, (String)"Node1");
        ValueEnforcer.notNull((Object)iMutableGraphNode2, (String)"Node2");
        this.m_aNode1 = iMutableGraphNode;
        this.m_aNode2 = iMutableGraphNode2;
    }

    @Override
    public final boolean isDirected() {
        return false;
    }

    @Override
    public boolean isRelatedTo(@Nullable IMutableGraphNode iMutableGraphNode) {
        return iMutableGraphNode != null && (this.m_aNode1.equals(iMutableGraphNode) || this.m_aNode2.equals(iMutableGraphNode));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMutableGraphNode> getAllConnectedNodes() {
        return new CommonsLinkedHashSet((Object[])new IMutableGraphNode[]{this.m_aNode1, this.m_aNode2});
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllConnectedNodeIDs() {
        return new CommonsLinkedHashSet((Object[])new String[]{(String)this.m_aNode1.getID(), (String)this.m_aNode2.getID()});
    }

    @Override
    @Nonnull
    public IMutableGraphNode getNode1() {
        return this.m_aNode1;
    }

    @Override
    @Nonnull
    public IMutableGraphNode getNode2() {
        return this.m_aNode2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        GraphRelation graphRelation = (GraphRelation)object;
        return this.m_aNode1.equals(graphRelation.m_aNode1) && this.m_aNode2.equals(graphRelation.m_aNode2);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aNode1).append((Object)this.m_aNode2).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("node1", (Object)this.m_aNode1).append("node2", (Object)this.m_aNode2).getToString();
    }
}

